// tailwind.config.js
export default {
    content: [
      "./resources/**/*.blade.php",
      "./resources/**/*.js",
      "./resources/**/*.vue",
    ],
    theme: {
      extend: {
        colors: {
          accent: { DEFAULT: "#2563eb", 600: "#1d4ed8" },
          base: { bg: "#f8fafc", border: "#e5e7eb" },
        },
        container: {
          center: true,
          padding: "1rem",
          screens: { sm: "640px", md: "768px", lg: "1024px", xl: "1200px" },
        },
        boxShadow: {
          card: "0 1px 2px rgba(0,0,0,.06), 0 2px 8px rgba(0,0,0,.04)",
        },
        borderRadius: { xl: "0.9rem" },
      },
    },
    plugins: [require('@tailwindcss/forms'), require('@tailwindcss/line-clamp')],
  };
