<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Zapatera\AdminProductController;
use App\Http\Controllers\Zapatera\AdminProductGalleryController;
use App\Http\Controllers\Zapatera\ProductMediaController;

/**
 * OJO:
 * Este archivo ya se carga dentro del grupo:
 * prefix('zapatera/admin')->name('zapatera.admin.')
 * en routes/web.php
 * Por eso aquí NO repetimos prefix/name.
 */

// CRUD de productos
Route::resource('products', AdminProductController::class);

// Galería (una sola vez; quitamos duplicado)
Route::get('products/{product}/gallery', [AdminProductGalleryController::class, 'show'])
    ->name('products.gallery');

// Edición de media (usado por el modal "Etiquetar")
Route::prefix('products/{product}')
    ->name('products.')
    ->group(function () {
        Route::get('media/{media}/edit',  [AdminProductController::class, 'editMedia'])->name('media.edit');
        Route::put('media/{media}',       [AdminProductController::class, 'updateMedia'])->name('media.update');
    });

// Subida AJAX (para el uploader)
Route::post('products/{product}/media', [ProductMediaController::class, 'storeAjax'])
    ->name('products.media.store.ajax');

// Eliminar media (AJAX opcional)
Route::delete('products/{product}/media/{media}', [ProductMediaController::class, 'destroyAjax'])
    ->name('products.media.destroy.ajax');
