<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Zapatera\{
    //CatalogController,
    AdminInventoryController,
    GestorPanelController,
    AdminPanelController,
    ReportesController
};

Route::prefix('zapatera')->name('zapatera.')->group(function () {
    // Catálogo público (token y uplift por query)
    //Route::get('/catalogo', [CatalogController::class, 'index'])->name('catalogo');

    // Panel del Gestor (configurar token, uplift, enlace de publicación)
    Route::get('/gestor', [GestorPanelController::class, 'index'])->name('gestor');
    Route::post('/gestor/guardar', [GestorPanelController::class, 'save'])->name('gestor.save'); // opcional, placeholder


    // Inventario (por variante)
    Route::get('/inventario', [AdminInventoryController::class, 'byVariant'])->name('inventario');

    // Reportes (placeholder)
    Route::get('/reportes', [ReportesController::class, 'index'])->name('reportes');
});
