<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Zapatera\AdminInventoryController;

Route::prefix('inventory')->name('inventory.')->group(function () {
    Route::get('/', [AdminInventoryController::class,'index'])->name('index');
    Route::get('/move', [AdminInventoryController::class,'move'])->name('move');
    Route::post('/move', [AdminInventoryController::class,'storeMove'])->name('move.store');

    // Historial general
    Route::get('/history', [AdminInventoryController::class,'history'])->name('history');
    // Historial filtrado por producto
    Route::get('/history/product/{product}', [AdminInventoryController::class,'history'])
        ->name('history.product');

    // API para construir el formulario dinámico de atributos
    Route::get('/attrs/{product}', [AdminInventoryController::class,'attrs'])->name('attrs');

    Route::delete('/one_movements/destoy/{id}', [AdminInventoryController::class, 'destroyMovement'])
                                                                                    ->name('one_movement.destroy');
    Route::delete('/all_movements/destoy/{batch_id}/{producto_id}', [AdminInventoryController::class, 'destroyAllMovements'])
                                                                                    ->name('all_movements.destroy');
    Route::delete('/stock_move_baches/destoy/{id}', [AdminInventoryController::class, 'destroyStockMoveBaches'])
                                                                                    ->name('stock_move_baches.destroy');
});
