<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Zapatera\AdminGestorController;

use App\Http\Controllers\Gestor\DashboardController;
use App\Http\Controllers\Gestor\UpliftController;

//middleware(['auth','role:admin'])->
Route::prefix('zapatera/admin')->name('zapatera.admin.')->group(function () {
    Route::resource('gestors', AdminGestorController::class)->except(['show']);
    Route::post('gestors/{gestor}/regenerate-token', [AdminGestorController::class,'regenerateToken'])->name('gestors.regenerate_token');
});

Route::middleware(['auth','role:gestor'])
    ->prefix('gestor')
    ->name('gestor.')
    ->group(function () {
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

        // Uplift global (perfil del gestor)
        Route::get('/uplift', [UpliftController::class, 'editGlobal'])->name('uplift.edit');
        Route::post('/uplift', [UpliftController::class, 'updateGlobal'])->name('uplift.update');

        // Uplift por producto
        Route::get('/uplift/products', [UpliftController::class, 'indexProducts'])->name('uplift.products.index');
        Route::post('/uplift/products/{product}', [UpliftController::class, 'storeOrUpdate'])->name('uplift.products.save');
        Route::delete('/uplift/products/{product}', [UpliftController::class, 'destroy'])->name('uplift.products.delete');
    });