<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Zapatera\AdminCategoryController;
use App\Http\Controllers\Zapatera\AdminCategoryDefaultsController;

Route::resource('categories', AdminCategoryController::class)->except(['show']);

// Guardar “por defecto” (checkboxes en el form de categoría)
Route::post('categories/{category}/defaults', [AdminCategoryDefaultsController::class, 'store'])
->name('categories.defaults.store');

// Aplicar masivamente a productos de la categoría
Route::post('categories/{category}/apply-defaults', [AdminCategoryDefaultsController::class, 'apply'])
->name('categories.defaults.apply');

