<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Zapatera\BarcodeController;
use App\Http\Controllers\Zapatera\BarcodePrintController;

// Ver el barcode de un producto (SVG directo)
Route::get('/barcode/{product}', [BarcodeController::class,'show'])->name('barcode.show');

// Listado para imprimir múltiples etiquetas (SIN {code})
Route::get('/barcodes/print', [BarcodePrintController::class,'print'])->name('barcode.print');

// Impresión rápida por code (para input del form)
Route::get('/barcode/{code}/quick-print', [BarcodePrintController::class,'quick'])
    ->where('code','.*')
    ->name('barcode.quick');

// Preview libre por code (para <img src=...>)
Route::get('/barcode-preview/{code}', [BarcodeController::class,'preview'])
    ->where('code','.*')
    ->name('barcode.preview');

// Impresora térmica
Route::get('/barcode/{code}/zpl', [BarcodePrintController::class,'zplOne'])
    ->where('code','.*')
    ->name('barcode.zplOne');

Route::get('/barcode/{code}/thermal', [BarcodePrintController::class,'thermal'])
    ->where('code','.*')
    ->name('barcode.thermal');