<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Zapatera\{AdminAttributeController, AdminAttributeValueController};

Route::resource('attributes', AdminAttributeController::class)->except(['show']);

Route::scopeBindings()->group(function () {
    Route::get('attributes/{attribute}/values', [AdminAttributeValueController::class,'index'])->name('attributes.values.index');
    Route::post('attributes/{attribute}/values', [AdminAttributeValueController::class,'store'])->name('attributes.values.store');
    Route::get('attributes/{attribute}/values/{value}/edit', [AdminAttributeValueController::class,'edit'])->name('attributes.values.edit');
    Route::put('attributes/{attribute}/values/{value}', [AdminAttributeValueController::class,'update'])->name('attributes.values.update');
    Route::delete('attributes/{attribute}/values/{value}', [AdminAttributeValueController::class,'destroy'])->name('attributes.values.destroy');
});