<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Zapatera\WhatsAppController;

use App\Http\Controllers\Zapatera\AdminPanelController;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

require __DIR__.'/web.zapatera.catalogo.php';

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Público con rate limit
Route::get('/whatsapp/order/{product}', [WhatsAppController::class, 'order'])
    ->name('whatsapp.order');

// ===== ADMIN =====
Route::middleware(['auth','verified','role:admin'])
    ->prefix('zapatera/admin')
    ->name('zapatera.admin.')
    ->group(function () {
        require __DIR__.'/web.zapatera.attributes.php';
        require __DIR__.'/web.zapatera.categories.php';
        require __DIR__.'/web.zapatera.currencies.php';
        require __DIR__.'/web.zapatera.barcodes.php';
        require __DIR__.'/web.zapatera.inventory.php';
        require __DIR__.'/web.zapatera.products.php';
        require __DIR__.'/web.zapatera.gestors.php';   // <-- aquí SOLO lo admin de gestors
        require __DIR__.'/web.zapatera.locales.php';
        require __DIR__.'/web.zapatera.accounting_period.php';
        require __DIR__.'/web.zapatera.roles.php';
        require __DIR__.'/web.zapatera.users.php';

        require __DIR__.'/web.zapatera.settings.php';
    });

Route::get('/zapatera/admin/panel', [AdminPanelController::class, 'index'])
    ->middleware(['auth','verified','role:admin'])
    ->name('zapatera.admin.panel');

require __DIR__.'/web.zapatera.php';
// ===== Panel del Gestor | Admin =====
require __DIR__.'/web.zapatera.gestors.php';

// ===== AUTH (¡IMPORTANTE!) =====
// Esto define la ruta con name('login') que necesita el middleware 'auth'
require __DIR__.'/auth.php';

if (app()->isLocal()) {
    Route::get('/logout', function () {
        Auth::logout();
        request()->session()->invalidate();
        request()->session()->regenerateToken();
        return redirect()->route('catalogo');
    })->middleware('auth');
}

