<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Gestor\{DashboardController, UpliftController};

Route::middleware(['auth','role:gestor'])
    ->prefix('gestor')
    ->name('gestor.')
    ->group(function () {
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/uplift', [UpliftController::class, 'editGlobal'])->name('uplift.edit');
        Route::post('/uplift', [UpliftController::class, 'updateGlobal'])->name('uplift.update');
        Route::get('/uplift/products', [UpliftController::class, 'indexProducts'])->name('uplift.products.index');
        Route::post('/uplift/products/{product}', [UpliftController::class, 'storeOrUpdate'])->name('uplift.products.save');
        Route::delete('/uplift/products/{product}', [UpliftController::class, 'destroy'])->name('uplift.products.delete');
    });
