@php
  $categorySlug = request('category_slug');
  $params       = request()->query();
  $keep         = collect($params)->except('page')->toArray();

  $selectedAttr = collect(request('attr', []));
  $activeSlug   = $categorySlug;
  $activeParent = optional($activeCategory)->parent;
@endphp

<aside class="md:col-span-1">
  <div class="nlx-card">
    <div class="nlx-card-body space-y-4">

      {{-- Todas --}}
      <a href="{{ route('catalogo', array_merge($keep, ['category_slug'=>null,'page'=>null])) }}"
         class="block w-full rounded-md px-4 py-2 font-semibold text-white bg-accent hover:bg-accent-600 transition">
        Todas
      </a>

      {{-- Categorías --}}
      <div>
        <div class="text-[11px] tracking-wide text-gray-500 uppercase mb-1">Categorías</div>
        <ul class="space-y-1">
          @foreach($categories as $cat)
            @php
              $isActiveRoot     = ($activeSlug === $cat->slug);
              $isParentOfActive = $activeParent && $activeParent->id === $cat->id;
              $showChildren     = $isActiveRoot || $isParentOfActive;
            @endphp

            <li>
              <a href="{{ route('catalogo', array_merge($keep, ['category_slug'=>$cat->slug,'page'=>null])) }}"
                 class="flex items-center justify-between rounded-md px-3 py-2
                        {{ $isActiveRoot ? 'bg-indigo-50 text-indigo-700' : 'hover:bg-gray-50 text-gray-800' }}">
                <span>{{ $cat->name }}</span>
              </a>

              @if($showChildren && $cat->children->isNotEmpty())
                <ul class="mt-1 ml-2 border-l border-gray-200 pl-2 space-y-1">
                  @foreach($cat->children as $sub)
                    <li>
                      <a href="{{ route('catalogo', array_merge($keep, ['category_slug'=>$sub->slug,'page'=>null])) }}"
                         class="block rounded-md px-3 py-1.5 text-sm
                                {{ $activeSlug === $sub->slug ? 'bg-indigo-50 text-indigo-700' : 'hover:bg-gray-50 text-gray-700' }}">
                        {{ $sub->name }}
                      </a>
                    </li>
                  @endforeach
                </ul>
              @endif
            </li>
          @endforeach
        </ul>
      </div>

      {{-- Filtros (atributos dinámicos) --}}
      <div>
        <div class="text-[11px] tracking-wide text-gray-500 uppercase mb-1">Filtros</div>

        <form method="GET" action="{{ route('catalogo') }}" class="space-y-3">
          {{-- Mantener todo menos page y attr (redefinimos attr) --}}
          @foreach(collect($keep)->except('attr') as $k => $v)
            @if(is_array($v))
              @foreach($v as $vk => $vv)
                <input type="hidden" name="{{ $k }}[{{ $vk }}]" value="{{ $vv }}">
              @endforeach
            @else
              <input type="hidden" name="{{ $k }}" value="{{ $v }}">
            @endif
          @endforeach

          {{-- Buscar --}}
          <div class="space-y-1">
            <label class="text-xs text-gray-600">Buscar</label>
            <input type="search" name="search"
                   value="{{ request('search') }}"
                   placeholder="Modelo o SKU..."
                   class="w-full rounded-md border-base-border focus:border-accent focus:ring-accent">
          </div>

          {{-- Atributos --}}
          @foreach($attributes as $attr)
            <div class="space-y-1">
              <label class="text-xs text-gray-600">{{ $attr->name }}</label>
              <select name="attr[{{ $attr->slug }}]"
                      class="w-full rounded-md border-base-border focus:border-accent focus:ring-accent">
                <option value="">Todos</option>
                @foreach($attr->values as $val)
                  <option value="{{ $val->slug }}"
                          @selected($selectedAttr->get($attr->slug) == $val->slug)>
                    {{ $val->value }}
                  </option>
                @endforeach
              </select>
            </div>
          @endforeach

          <button class="nlx-btn-accent w-full">Filtrar</button>
        </form>
      </div>

    </div>
  </div>
</aside>
