@extends('layouts.app')

@section('content')
<div class="container py-4">
  @if(session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
  @endif

  <h5 class="mb-3">Área del Gestor</h5>

  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <strong>Publicación de catálogo</strong>
      <code class="small">URL: {{ $publishUrl }}</code>
    </div>
    <div class="card-body">
      <form class="row gy-2 gx-3 align-items-end" method="post" action="{{ route('zapatera.gestor.save') }}">
        @csrf
        <div class="col-sm-3">
          <label class="form-label small">Mi token</label>
          <input name="token" class="form-control" value="{{ old('token', $gestor->token) }}">
        </div>
        <div class="col-sm-3">
          <label class="form-label small">Uplift %</label>
          <input name="uplift" class="form-control" value="{{ old('uplift', $gestor->uplift_pct_default) }}">
        </div>
        <div class="col-sm-4">
          <label class="form-label small">WhatsApp</label>
          <input name="phone" class="form-control" value="{{ old('phone', $gestor->phone) }}">
        </div>
        <div class="col-sm-2 d-grid">
          <button class="btn btn-primary" type="submit">Guardar</button>
        </div>
      </form>
      <p class="small text-muted mt-2 mb-0">Comparte tu enlace con token y uplift para que tus clientes vean tu precio.</p>
    </div>
  </div>
</div>
@endsection
