@extends('layouts.app') {{-- o tu layout Tailwind --}}

@section('content')
<div class="container mx-auto px-4 py-8">
  <h1 class="text-xl font-semibold text-gray-900 mb-2">Catálogo de Productos</h1>
  <p class="text-gray-600 mb-6">
    Filtrado por categoría y subcategorías. Selecciona y agrega al carrito. Pedido por WhatsApp.
  </p>

  <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
    {{-- SIDEBAR --}}
    @include('zapatera.partials.filters')

    {{-- GRID de productos --}}
    <section class="md:col-span-3">
      @if($products->count())
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-3">
          @foreach($products as $p)
            <x-product-card
              :title="is_array($p) ? ($p['name'] ?? '') : $p->name"
              :sku="is_array($p) ? ($p['sku'] ?? null) : $p->sku"
              :price="'$'.number_format(is_array($p) ? ($p['price'] ?? $p['base_price'] ?? 0) : ($p->price ?? $p->base_price), 2)"
              :image="is_array($p)
                        ? (($p['image'] ?? null) ? asset($p['image']) : asset('img/placeholder_zapato_detalle.svg'))
                        : ($p->primaryImage?->path ? asset($p->primaryImage->path) : asset('img/placeholder_zapato_detalle.svg'))"
              :stock="is_array($p) ? ($p['stock_total'] ?? 0) : ($p->variants?->sum(fn($v)=> optional($v->stock)->qty ?? 0) ?? 0)"
              :url="route('whatsapp.order', is_array($p) ? ($p['id'] ?? null) : $p->id)"
            />
          @endforeach
        </div>

        <x-ui.pagination :paginator="$products" :window="2" :show-summary="false">
            <x-slot:middle>
              <x-ui.per-page class="hidden sm:inline-flex" />
            </x-slot:middle>
        </x-ui.pagination>
      @else
        <div class="text-gray-500">No hay productos.</div>
      @endif
    </section>
  </div>
</div>
@endsection
