<x-admin-layout title="Roles de {{ $user->name }}">
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Asignar roles</h1>
      <p class="text-sm text-gray-500">Selecciona los roles para este usuario.</p>
    </x-slot>

    <section class="py-6">
      <div class="max-w-xl mx-auto px-4">
        <div class="bg-white rounded-xl shadow ring-1 ring-gray-200">
          <form method="POST" action="{{ route('zapatera.admin.users.roles.update', $user) }}" class="p-6 space-y-4">
            @csrf @method('PUT')

            <div class="space-y-2">
              @foreach($roles as $r)
                <label class="flex items-center gap-3">
                  <input type="checkbox" name="roles[]"
                         value="{{ $r }}"
                         @checked($user->hasRole($r))
                         class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                  <span class="text-sm text-gray-800">{{ $r }}</span>
                </label>
              @endforeach
            </div>

            @error('roles.*')
              <p class="text-sm text-red-600">{{ $message }}</p>
            @enderror

            <div class="pt-2">
              <button class="inline-flex items-center rounded-lg bg-blue-600 px-4 py-2 text-white hover:bg-blue-700">
                Guardar
              </button>
              <a href="{{ route('zapatera.admin.users.index') }}"
                 class="ml-2 text-sm text-gray-600 hover:text-gray-800">Cancelar</a>
            </div>

            <p class="text-[11px] text-gray-500 mt-2">
              **Nota:** No puedes quitarte tu propio rol <b>admin</b>.
            </p>
          </form>
        </div>
      </div>
    </section>
  </x-admin-layout>
