<x-admin-layout title="Usuarios">
    <x-slot name="header">
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-xl font-semibold text-gray-900">Usuarios</h1>
          <p class="text-sm text-gray-500">Gestiona cuentas y roles.</p>
        </div>
        {{-- Badge de roles del usuario (opcional) --}}
        <x-user-role-badges />
      </div>
    </x-slot>

    <section class="py-6">
      <div class="max-w-6xl mx-auto px-4">
        <form method="GET" action="{{ route('zapatera.admin.users.index') }}"
            class="grid grid-cols-1 md:grid-cols-12 gap-3 mb-5 items-end">

            <div class="md:col-span-6">
                <label for="q" class="block text-sm font-medium text-gray-700 mb-1">Buscar</label>
                <input id="q" type="text" name="q" value="{{ $q ?? request('q') }}"
                    placeholder="Buscar nombre o email"
                    class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" />
            </div>

            <div class="md:col-span-6 flex flex-wrap gap-2">
                <button class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-white bg-indigo-600 hover:bg-indigo-700
                            focus:outline-none focus:ring-2 focus:ring-indigo-500">
                Filtrar
                </button>

                @if(request()->filled('q'))
                <a href="{{ route('zapatera.admin.users.index') }}"
                    class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-indigo-700 bg-indigo-50 border border-indigo-200
                            hover:bg-indigo-100">
                    Limpiar
                </a>
                @endif

                <a href="{{ route('zapatera.admin.users.create') }}"
                class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                        rounded-lg text-sm font-semibold text-white bg-emerald-600 hover:bg-emerald-700">
                + Nuevo
                </a>
            </div>
        </form>


        <div class="bg-white rounded-xl shadow ring-1 ring-gray-200 overflow-hidden">
          <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
              <tr class="text-left text-xs font-semibold text-gray-600 uppercase">
                <th class="px-4 py-2">Nombre</th>
                <th class="px-4 py-2">Email</th>
                <th class="px-4 py-2">Roles</th>
                <th class="px-4 py-2 text-right">Acciones</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
              @foreach($users as $u)
                <tr class="hover:bg-gray-50">
                  <td class="px-4 py-2 text-sm font-medium text-gray-900">{{ $u->name }}</td>
                  <td class="px-4 py-2 text-sm text-gray-700">{{ $u->email }}</td>
                  <td class="px-4 py-2 text-sm text-gray-700">
                    @forelse($u->getRoleNames() as $r)
                      <span class="inline-flex items-center rounded-full bg-indigo-50 text-indigo-700 border border-indigo-100 px-2 py-0.5 text-xs">{{ $r }}</span>
                    @empty
                      <span class="text-gray-400">—</span>
                    @endforelse
                  </td>
                  <td class="px-4 py-2 text-right">
                    <a href="{{ route('zapatera.admin.users.edit', $u) }}"
                       class="inline-flex items-center rounded-md border border-gray-300 px-3 py-1.5 text-sm text-gray-700 hover:bg-gray-50">Editar</a>
                    @if($u->id !== auth()->id())
                      <form method="POST" action="{{ route('zapatera.admin.users.destroy', $u) }}"
                            class="inline"
                            onsubmit="return confirm('¿Eliminar usuario?');">
                        @csrf @method('DELETE')
                        <button class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-sm text-white hover:bg-red-700">
                          Eliminar
                        </button>
                      </form>
                    @endif
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>

        <div class="mt-4">{{ $users->links() }}</div>
      </div>
    </section>
  </x-admin-layout>
