<x-admin-layout title="Nuevo usuario">
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Crear usuario</h1>
      <p class="text-sm text-gray-500">Define datos básicos y roles.</p>
    </x-slot>

    <section class="py-6">
      <div class="max-w-2xl mx-auto px-4">
        <div class="bg-white rounded-xl shadow ring-1 ring-gray-200">
          <form method="POST" action="{{ route('zapatera.admin.users.store') }}" class="p-6 space-y-6">
            @csrf
            <div class="space-y-1">
              <label class="text-sm font-medium text-gray-700">Nombre</label>
              <input name="name" value="{{ old('name') }}" required
                     class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500 bg-blue-50/30 focus:bg-white">
              @error('name') <p class="text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div class="space-y-1">
              <label class="text-sm font-medium text-gray-700">Email</label>
              <input name="email" type="email" value="{{ old('email') }}" required
                     class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500 bg-blue-50/30 focus:bg-white">
              @error('email') <p class="text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
              <div class="space-y-1">
                <label class="text-sm font-medium text-gray-700">Password</label>
                <input name="password" type="password" required
                       class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500 bg-blue-50/30 focus:bg-white">
                @error('password') <p class="text-sm text-red-600">{{ $message }}</p> @enderror
              </div>
              <div class="space-y-1">
                <label class="text-sm font-medium text-gray-700">Confirmación</label>
                <input name="password_confirmation" type="password" required
                       class="w-full rounded-lg border-gray-300 focus:ring-blue-500 focus:border-blue-500 bg-blue-50/30 focus:bg-white">
              </div>
            </div>

            <div class="space-y-2">
              <label class="text-sm font-medium text-gray-700">Roles</label>
              <div class="grid grid-cols-2 gap-2">
                @foreach($roles as $r)
                  <label class="flex items-center gap-3">
                    <input type="checkbox" name="roles[]" value="{{ $r }}"
                           class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                    <span class="text-sm text-gray-800">{{ $r }}</span>
                  </label>
                @endforeach
              </div>
              <p class="text-[11px] text-gray-500">Este módulo no permite asignar <b>gestor</b>; se gestiona en su sección.</p>
            </div>

            <div class="pt-2">
              <button class="inline-flex items-center rounded-lg bg-blue-600 px-4 py-2 text-white hover:bg-blue-700">Guardar</button>
              <a href="{{ route('zapatera.admin.users.index') }}" class="ml-2 text-sm text-gray-600 hover:text-gray-800">Cancelar</a>
            </div>
          </form>
        </div>
      </div>
    </section>
  </x-admin-layout>
