<section class="py-6">
    <div class="max-w-3xl mx-auto px-4 space-y-6">

      @if ($errors->any())
        <div class="rounded-md border border-red-200 bg-red-50 text-red-700 px-4 py-3 text-sm">
          <ul class="list-disc pl-5">
            @foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach
          </ul>
        </div>
      @endif

      @if(session('status'))
        <div class="rounded-md border border-green-200 bg-green-50 text-green-700 px-4 py-3 text-sm">
          {{ session('status') }}
        </div>
      @endif

      <form method="POST" action="{{ $action }}" class="space-y-6">
        @csrf
        @if($method !== 'POST') @method($method) @endif

        {{-- Card: Identificación --}}
        <div class="rounded-xl border border-gray-200 p-5 space-y-4 bg-white">
          <div class="grid sm:grid-cols-2 gap-4">
            <div>
              <label class="block text-sm font-medium text-gray-700">Key</label>
              <input name="key" class="w-full rounded-lg border border-gray-300 px-3 py-2"
                     value="{{ old('key', $setting->key) }}" required>
              <p class="text-xs text-gray-500 mt-1">Ej: <code>inventory.totals.render_type</code></p>
            </div>

            <div>
              <label class="block text-sm font-medium text-gray-700">Tipo</label>
              @php $type = old('type', $setting->type ?? 'string'); @endphp
              <select name="type" id="type" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                @foreach(['string','bool','int','float','json'] as $t)
                  <option value="{{ $t }}" @selected($type===$t)>{{ $t }}</option>
                @endforeach
              </select>
            </div>

            <div>
              <label class="block text-sm font-medium text-gray-700">Grupo</label>
              <input name="group" class="w-full rounded-lg border border-gray-300 px-3 py-2"
                     value="{{ old('group', $setting->group) }}" placeholder="inventory, ui, orders...">
            </div>

            <div class="flex items-center gap-2 pt-6 sm:pt-0">
              <input type="hidden" name="autoload" value="0">
              <input id="autoload" type="checkbox" name="autoload" value="1"
                     @checked(old('autoload', $setting->autoload ?? true))
                     class="h-5 w-5">
              <label for="autoload" class="text-sm text-gray-700">Autoload</label>
            </div>
          </div>
        </div>

        {{-- Card: Valor dinámico --}}
        @php
          $raw = is_array($setting->value) && array_key_exists('v',$setting->value)
                ? $setting->value['v'] : $setting->value;
        @endphp

        <div class="rounded-xl border border-gray-200 p-5 space-y-3 bg-white">
          <label class="block text-sm font-medium text-gray-700">Valor</label>

          {{-- string --}}
          <div data-type="string" class="{{ $type==='string' ? '' : 'hidden' }}">
            <input name="value_string" class="w-full rounded-lg border border-gray-300 px-3 py-2"
                   value="{{ old('value_string', $type==='string' ? (string)($raw ?? '') : '') }}">
          </div>

          {{-- bool --}}
          <div data-type="bool" class="{{ $type==='bool' ? '' : 'hidden' }}">
            <label class="inline-flex items-center gap-2">
              <input type="hidden" name="value_bool" value="0">
              <input type="checkbox" name="value_bool" value="1"
                     @checked(old('value_bool', $type==='bool' ? (bool)($raw ?? false) : false))
                     class="h-5 w-5">
              <span class="text-sm text-gray-700">Sí / No</span>
            </label>
          </div>

          {{-- int --}}
          <div data-type="int" class="{{ $type==='int' ? '' : 'hidden' }}">
            <input type="number" step="1" name="value_int"
                   class="w-full rounded-lg border border-gray-300 px-3 py-2"
                   value="{{ old('value_int', $type==='int' ? (int)($raw ?? 0) : '') }}">
          </div>

          {{-- float --}}
          <div data-type="float" class="{{ $type==='float' ? '' : 'hidden' }}">
            <input type="number" step="0.01" name="value_float"
                   class="w-full rounded-lg border border-gray-300 px-3 py-2"
                   value="{{ old('value_float', $type==='float' ? (float)($raw ?? 0) : '') }}">
          </div>

          {{-- json --}}
          <div data-type="json" class="{{ $type==='json' ? '' : 'hidden' }}">
            <textarea name="value_json" rows="8"
                      class="w-full rounded-lg border border-gray-300 px-3 py-2"
                      placeholder='{"foo":"bar"}'>{{ old('value_json', $type==='json' ? json_encode($raw, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) : '') }}</textarea>
            <p class="text-xs text-gray-500 mt-1">Debe ser JSON válido.</p>
          </div>
        </div>

        {{-- Acciones --}}
        <div class="flex items-center gap-2">
          <button class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Guardar</button>
          <a href="{{ route('zapatera.admin.settings.index') }}"
             class="px-4 py-2 rounded-lg border border-gray-300 hover:bg-gray-50">Cancelar</a>
        </div>
      </form>
    </div>
  </section>

  <script>
  document.addEventListener('DOMContentLoaded', () => {
    const sel = document.getElementById('type');
    const toggle = () => {
      document.querySelectorAll('[data-type]').forEach(el => el.classList.add('hidden'));
      const target = document.querySelector(`[data-type="${sel.value}"]`);
      if (target) target.classList.remove('hidden');
    };
    sel.addEventListener('change', toggle);
    toggle();
  });
  </script>
