<x-admin-layout title="Configuración">
    <x-slot:header>
      <div>
        <h1 class="text-xl font-semibold text-gray-900">Configuración</h1>
        <p class="text-sm text-gray-500">Administra las opciones globales del sistema.</p>
      </div>
      <x-user-role-badges />
    </x-slot:header>

    <section class="py-6">
      <div class="max-w-6xl mx-auto px-4">

        {{-- Filtros (compacto como Atributos) --}}
        <form method="GET" class="mb-4 flex flex-col gap-3 sm:flex-row sm:items-end">
          <div class="sm:basis-1/2">
            <label class="block text-sm text-gray-700 mb-1">Buscar</label>
            <input name="q" value="{{ $q }}"
                   class="w-full rounded-lg border border-gray-300 px-3 py-2"
                   placeholder="Buscar por key o grupo…">
          </div>

          <div class="sm:basis-1/4">
            <label class="block text-sm text-gray-700 mb-1">Grupo</label>
            <select name="group" class="w-full rounded-lg border border-gray-300 px-3 py-2">
              <option value="">— todos —</option>
              @foreach($groups as $g)
                <option value="{{ $g }}" @selected($group===$g)>{{ $g }}</option>
              @endforeach
            </select>
          </div>

          <div class="flex gap-2 sm:ml-auto">
            <button class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Filtrar</button>
            <a href="{{ route('zapatera.admin.settings.index') }}"
               class="px-4 py-2 rounded-lg border border-gray-300 hover:bg-gray-50">Limpiar</a>
            <a href="{{ route('zapatera.admin.settings.create') }}"
               class="px-4 py-2 rounded-lg bg-emerald-600 text-white hover:bg-emerald-700">+ Nueva opción</a>
          </div>
        </form>

        {{-- Tabla (look & feel de Atributos) --}}
        <div class="overflow-hidden rounded-xl border border-gray-200">
          <table class="min-w-full text-sm">
            <thead class="bg-gray-50 text-gray-600">
              <tr>
                <th class="px-4 py-3 text-left">ID</th>
                <th class="px-4 py-3 text-left">KEY</th>
                <th class="px-4 py-3 text-left">VALOR</th>
                <th class="px-4 py-3 text-left">TIPO</th>
                <th class="px-4 py-3 text-left">GRUPO</th>
                <th class="px-4 py-3 text-left">AUTOLOAD</th>
                <th class="px-4 py-3 text-right">ACCIONES</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
              @forelse($settings as $s)
                @php
                  $raw = is_array($s->value) && array_key_exists('v', $s->value) ? $s->value['v'] : $s->value;
                  $preview = is_array($raw) ? json_encode($raw, JSON_UNESCAPED_UNICODE) : (string) $raw;
                  if (mb_strlen($preview) === 0) $preview = '—';
                  elseif (mb_strlen($preview) > 36) $preview = mb_substr($preview, 0, 36).'…';
                @endphp
                <tr class="hover:bg-gray-50">
                  <td class="px-4 py-3 text-gray-700">{{ $s->id }}</td>
                  <td class="px-4 py-3 font-medium text-gray-900">{{ $s->key }}</td>
                  <td class="px-4 py-3 text-gray-700">{{ $preview }}</td>
                  <td class="px-4 py-3">
                    <span class="inline-flex items-center px-2 py-0.5 rounded-full border
                      {{ in_array($s->type,['json','array']) ? 'bg-purple-50 text-purple-700 border-purple-200' : 'bg-gray-50 text-gray-700 border-gray-200' }}">
                      {{ $s->type }}
                    </span>
                  </td>
                  <td class="px-4 py-3">
                    <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-sky-50 text-sky-700 border border-sky-200">
                      {{ $s->group ?? '—' }}
                    </span>
                  </td>
                  <td class="px-4 py-3">
                    @if($s->autoload)
                      <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full bg-green-50 text-green-700 border border-green-200">
                        <span class="h-1.5 w-1.5 rounded-full bg-green-500"></span> Sí
                      </span>
                    @else
                      <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-gray-50 text-gray-600 border border-gray-200">
                        No
                      </span>
                    @endif
                  </td>
                  <td class="px-4 py-3">
                    <div class="flex justify-end gap-2">
                      <a href="{{ route('zapatera.admin.settings.edit', $s) }}"
                         class="px-3 py-1.5 rounded-lg border border-gray-300 hover:bg-white">Editar</a>
                      <form action="{{ route('zapatera.admin.settings.destroy', $s) }}" method="POST"
                            onsubmit="return confirm('¿Eliminar esta opción?')">
                        @csrf @method('DELETE')
                        <button class="px-3 py-1.5 rounded-lg bg-red-600 text-white hover:bg-red-700">Eliminar</button>
                      </form>
                    </div>
                  </td>
                </tr>
              @empty
                <tr>
                  <td colspan="7" class="px-4 py-6 text-center text-gray-500">No hay opciones.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>

        <div class="mt-4 flex justify-end">
          {{ $settings->links() }}
        </div>
      </div>
    </section>
  </x-admin-layout>
