{{-- resources/views/zapatera/admin/products/partials/scripts.blade.php --}}

@php
  // Exponer rates a JS (usado por profit)
  $currencies = \App\Models\Currency::orderByDesc('is_primary')->orderBy('code')->get();
  $currencyRates = $currencies->map(fn($c)=>[
    'id' => $c->id,
    'code' => $c->code,
    'rate' => (float)$c->rate_to_primary,
    'is_primary' => (bool)$c->is_primary,
  ]);
@endphp

@push('scripts')
<script>
// ==== Lightbox vanilla ====
document.addEventListener('DOMContentLoaded', function () {
  const $lb     = document.getElementById('nlx-lightbox');
  const $lbImg  = document.getElementById('nlx-lightbox-img');
  const $lbBack = $lb?.querySelector('.nlx-lightbox-backdrop');
  const $lbX    = $lb?.querySelector('.nlx-lightbox-close');

  if (!$lb || !$lbImg) return;

  function openLightbox(src) {
    // sin fetch para evitar CORS; confíamos en cache-buster que trae el src
    $lbImg.src = src || '';
    $lb.classList.remove('hidden');
  }
  function closeLightbox() {
    $lb.classList.add('hidden');
    $lbImg.src = '';
  }

  $lbBack?.addEventListener('click', closeLightbox);
  $lbX?.addEventListener('click', closeLightbox);
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && !$lb.classList.contains('hidden')) closeLightbox();
  });

  const grids = [ document.getElementById('nlx-previews'), document ];
  grids.forEach(root => {
    if (!root) return;
    root.addEventListener('click', (e) => {
      const img = e.target.closest('img[data-enlargeable]');
      if (!img) return;
      e.preventDefault();
      openLightbox(img.getAttribute('src'));
    }, true);
  });
});
</script>
@endpush

@push('scripts')
<script>
// ==== Ganancia / monedas ====
(() => {
  try {
    window.currencyRates = Array.isArray(window.currencyRates) && window.currencyRates.length
      ? window.currencyRates
      : @json($currencyRates ?? []);
  } catch (e) {
    window.currencyRates = window.currencyRates || [];
  }

  const $ = (id) => document.getElementById(id);
  const debounce = (fn, ms=140) => { let t; return (...a)=>{ clearTimeout(t); t=setTimeout(()=>fn(...a), ms); }; };
  const log = (...args) => console.debug('[profit]', ...args);

  let tries = 0;
  const maxTries = 50;
  function startWhenReady() {
    const costEl     = $('cost');
    const costCurEl  = $('cost_currency_id');
    const baseEl     = $('base_price');
    const baseCurEl  = $('base_price_currency_id');
    const out        = $('profit-text');

    if (!costEl || !costCurEl || !baseEl || !baseCurEl || !out) {
      if (tries++ < maxTries) return setTimeout(startWhenReady, 100);
      log('No encontré elementos necesarios. Abortando.');
      return;
    }
    if (out.dataset.profitInit === '1') return;
    out.dataset.profitInit = '1';

    const rates   = Array.isArray(window.currencyRates) ? window.currencyRates : [];
    const primary = rates.find(x => x && x.is_primary) || null;
    const find = (id) => rates.find(x => String(x.id) === String(id)) || {};
    const rate = (id) => Number(find(id).rate || 0);
    const code = (id) => find(id).code || '';

    const nf = new Intl.NumberFormat(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    const fmt = (n) => nf.format(Number(n) || 0);
    const badge = (n, lbl='') => {
      const ok = (Number(n)||0) >= 0;
      return `<span class="inline-flex items-center rounded px-1.5 py-0.5 text-xs ${ok ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'}">${fmt(n)}${lbl ? ' ' + lbl : ''}</span>`;
    };

    function calc() {
      const cost    = Number(costEl.value) || 0;
      const base    = Number(baseEl.value) || 0;
      const costCur = costCurEl.value;
      const baseCur = baseCurEl.value;
      if (!cost && !base) { out.textContent = '—'; return; }

      const rCost = rate(costCur) || 1;
      const rBase = rate(baseCur) || 1;
      const costP   = cost * rCost;
      const baseP   = base * rBase;
      const profitP = baseP - costP;

      if (costCur === baseCur) {
        out.innerHTML = `Ganancia: <strong>${badge(base - cost, code(costCur))}</strong>`;
        return;
      }
      const profitInBase = rBase ? (profitP / rBase) : 0;
      const profitInCost = rCost ? (profitP / rCost) : 0;
      const pCode        = primary?.code || 'PRINC';
      out.innerHTML = [
        `Ganancia en ${pCode}: <strong>${badge(profitP, primary?.code || '')}</strong>`,
        `≈ en ${code(baseCur)}: <strong>${badge(profitInBase, code(baseCur))}</strong>`,
        `≈ en ${code(costCur)}: <strong>${badge(profitInCost, code(costCur))}</strong>`
      ].join('<br>');
    }

    const onChange = debounce(calc, 120);
    [costEl, costCurEl, baseEl, baseCurEl].forEach(el => {
      el.addEventListener('input', onChange, { passive: true });
      el.addEventListener('change', onChange);
    });

    window.recalcProfit = calc;
    calc();
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', startWhenReady);
  } else {
    startWhenReady();
  }
  window.addEventListener('turbo:load', startWhenReady);
  document.addEventListener('livewire:navigated', startWhenReady);
})();
</script>
@endpush

@push('scripts')
<script>
// ==== Código de barras (preview y toggles) ====
document.addEventListener('DOMContentLoaded', function () {
  const $input   = document.getElementById('barcode-input');
  const $wrap    = document.getElementById('barcode-preview-wrap');
  const $box     = document.getElementById('barcode-preview-ajax');
  const $hint    = document.getElementById('barcode-preview-hint');
  const $thermal = document.getElementById('barcode-thermal');
  const $zpl     = document.getElementById('barcode-zpl');

  if (!$input || !$box) return;

  const buildPreviewUrl = (code) => {
    const tpl = "{{ route('zapatera.admin.barcode.preview', ['code' => '__CODE__']) }}";
    return tpl.replace('__CODE__', encodeURIComponent(code));
  };
  const buildThermalUrl = (code) => {
    const tpl = "{{ route('zapatera.admin.barcode.thermal', ['code' => '__CODE__']) }}";
    return tpl.replace('__CODE__', encodeURIComponent(code));
  };
  const buildZplUrl = (code) => {
    const tpl = "{{ route('zapatera.admin.barcode.zplOne', ['code' => '__CODE__']) }}";
    return tpl.replace('__CODE__', encodeURIComponent(code));
  };

  async function renderBarcode(code) {
    $box.innerHTML = '<span class="nlx-spinner" aria-label="cargando" style="width:22px;height:22px;border-radius:50%;border:3px solid #e5e7eb;border-top-color:#2563eb;display:inline-block;animation:spin .8s linear infinite"></span>';
    $hint.textContent = code;
    try {
      const res = await fetch(buildPreviewUrl(code), { headers: { 'Accept': 'image/svg+xml' }});
      if (!res.ok) throw new Error('HTTP '+res.status);
      const svgText = await res.text();
      $box.innerHTML = svgText;
    } catch (e) {
      $box.innerHTML = '<div class="text-red-600 text-sm">No se pudo generar el código.</div>';
    }
  }

  let t = null;
  const onChange = () => {
    const code = ($input.value || '').trim();
    if (code.length >= 5) {
      $wrap.classList.remove('hidden');
      renderBarcode(code);
      if ($thermal) { $thermal.href = buildThermalUrl(code); $thermal.classList.remove('hidden'); }
      if ($zpl)     { $zpl.href     = buildZplUrl(code);     $zpl.classList.remove('hidden'); }
    } else {
      $wrap.classList.add('hidden');
      if ($thermal) $thermal.classList.add('hidden');
      if ($zpl)     $zpl.classList.add('hidden');
    }
  };

  $input.addEventListener('input', () => { clearTimeout(t); t = setTimeout(onChange, 180); });

  const initial = ($input.value || '').trim();
  if (initial.length >= 5) { $wrap.classList.remove('hidden'); renderBarcode(initial); }
});
</script>
@endpush

@push('scripts')
<script>
// ==== Uploader AJAX (drag & drop + barra de progreso) ====
(function(){
  const root    = document.querySelector('[x-data="mediaTagger()"]');
  const canAjax = root?.getAttribute('data-can-ajax') === '1';
  const ajaxUrl = root?.getAttribute('data-ajax-url') || null;

  const $drop   = document.getElementById('nlx-uploader');
  const $input  = document.getElementById('nlx-input');
  const $browse = document.getElementById('nlx-browse');
  const $prevs  = document.getElementById('nlx-previews');
  const $count  = document.getElementById('nlx-count');
  const $maxMb  = document.getElementById('nlx-max-mb');
  const $hint   = document.getElementById('nlx-uploader-hint');

  if (!$drop || !$input) return;

  // ⚠️ Asegúrate de que este input NO participe cuando se envía el form
  //    (evita recrear imágenes al guardar)
  $input.removeAttribute('name');

  const MAX_MB   = 5;
  const ACCEPTED = ['image/jpeg','image/png','image/webp'];
  $maxMb.textContent = MAX_MB;

  const csrf = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '{{ csrf_token() }}';

  function toast(msg, isErr=false) {
    const el = document.createElement('div');
    el.textContent = msg;
    el.className = `fixed bottom-4 left-1/2 -translate-x-1/2 px-3 py-2 rounded-lg text-white ${isErr ? 'bg-red-600' : 'bg-emerald-600'}`;
    el.style.zIndex = 9999; document.body.appendChild(el);
    setTimeout(()=>el.remove(), 1800);
  }

  // --- URL normalizer (evita /tienda/storage/...)
  function normalizeMediaUrl(raw) {
    let u = String(raw || '').trim();
    if (!u) return '';

    // absoluta -> dejar
    if (/^https?:\/\//i.test(u)) {
      // si viniera con "/tienda/storage/", corrígelo
      return u.replace(/\/tienda\/storage\//i, '/storage/');
    }

    // quitar "public/" si viniera
    u = u.replace(/^public\//, '');

    // forzar leading slash si empieza por "storage/"
    if (u.startsWith('storage/')) u = '/' + u;

    // si no empieza por "/", fuerza root
    if (!u.startsWith('/')) u = '/' + u;

    // devolver absoluta (opcional; puedes devolver solo u)
    return location.origin + u;
  }

  function fmtBytes(bytes) {
    const kb = bytes / 1024;
    if (kb < 1024) return `${kb.toFixed(0)} KB`;
    return `${(kb/1024).toFixed(2)} MB`;
  }

  function fileValid(file) {
    if (!ACCEPTED.includes(file.type)) { toast(`Tipo no permitido: ${file.name}`, true); return false; }
    if ((file.size/1024/1024) > MAX_MB) { toast(`Muy grande: ${file.name}`, true); return false; }
    return true;
  }

  function renderUploadingCard(file) {
    const card = document.createElement('div');
    card.className = 'rounded-lg overflow-hidden relative bg-white border border-gray-200';

    const img = document.createElement('img');
    img.alt = file.name;
    img.className = 'w-full h-36 object-cover';
    const reader = new FileReader();
    reader.onload = e => { img.src = e.target.result; };
    reader.readAsDataURL(file);

    const meta = document.createElement('div');
    meta.className = 'px-2 py-1 text-xs text-gray-600 flex items-center justify-between';
    meta.innerHTML = `<span class="truncate max-w-[70%]">${file.name}</span><span>${fmtBytes(file.size)}</span>`;

    const barWrap = document.createElement('div');
    barWrap.className = 'h-1 bg-gray-200';
    const bar = document.createElement('div');
    bar.className = 'h-1 bg-indigo-500 transition-all';
    bar.style.width = '0%';
    barWrap.appendChild(bar);

    card.appendChild(img);
    card.appendChild(meta);
    card.appendChild(barWrap);

    $prevs?.prepend(card);

    return { card, bar };
  }

  // Inserta la nueva “media-card” en la columna derecha
  function injectMediaToRightPanel(media) {
    const rightWrap = document.querySelector('.media-card')?.parentElement
                   || document.querySelector('.mt-1.flex.flex-wrap.gap-3');
    if (!rightWrap) return;

    const card = document.createElement('div');
    card.className = 'flex flex-col items-center border rounded-xl p-2 media-card';
    card.dataset.mediaId = media.id;

    const img = document.createElement('img');
    img.alt = 'imagen';
    img.setAttribute('data-enlargeable','');
    img.className = 'h-[90px] w-[120px] object-cover rounded cursor-zoom-in';

    const raw = String(media.url || '').trim(); // ej: "/storage/product_media/xxx.jpg?t=..."
    let finalUrl = raw;

    // si por algún motivo llegara absoluta, no le pegues otro origin
    if (/^https?:\/\//i.test(raw)) {
    // además, corrige /tienda/storage -> /storage si apareciera
    finalUrl = raw.replace(/\/tienda\/storage\//i, '/storage/');
    } else {
    // si viene "storage/..." sin slash, ponlo
    if (raw.startsWith('storage/')) finalUrl = '/'+raw;
    // si no empieza por '/', añádelo
    if (!finalUrl.startsWith('/')) finalUrl = '/'+finalUrl;
    // puedes dejarla relativa o absolutizar UNA vez:
    // finalUrl = location.origin + finalUrl; // opcional
    }

    img.src = finalUrl;

    card.appendChild(img);

    const wrapPrimary = document.createElement('div');
    wrapPrimary.className = 'mt-3 flex items-center justify-center gap-2 media-primary-wrap';

    const radio = document.createElement('input');
    radio.type = 'radio';
    radio.name = 'primary_media_id';
    radio.value = String(media.id);
    radio.id = `primary_media_${media.id}`;
    radio.className = 'h-4 w-4 text-indigo-600 focus:ring-indigo-500';

    const label = document.createElement('label');
    label.className = 'text-sm text-gray-700';
    label.setAttribute('for', `primary_media_${media.id}`);
    label.textContent = 'Marcar como principal';

    wrapPrimary.appendChild(radio);
    wrapPrimary.appendChild(label);
    card.appendChild(wrapPrimary);

    const small = document.createElement('small');
    small.className = 'mt-1 text-gray-500';
    small.textContent = `#${media.id}`;
    card.appendChild(small);

    const tagBtn = document.createElement('button');
    tagBtn.type = 'button';
    tagBtn.className = 'mt-1 text-xs text-indigo-600 hover:underline';
    tagBtn.textContent = 'Etiquetar';
    tagBtn.addEventListener('click', () => {
      if (window.mediaTagger && typeof window.mediaTagger.open === 'function') {
        window.mediaTagger.open({ id: media.id, is_primary: false, selected: [] });
      }
    });
    card.appendChild(tagBtn);

    const chips = document.createElement('div');
    chips.className = 'mt-2 flex flex-wrap justify-center gap-1 media-chips';
    chips.setAttribute('data-media-id', media.id);
    card.appendChild(chips);

    rightWrap.prepend(card);

    // Checkbox en “Eliminar imágenes”
    const delContainer = document.querySelector('div.mt-1.flex.flex-wrap.gap-4');
    if (delContainer) {
      const labelDel = document.createElement('label');
      labelDel.className = 'inline-flex items-center gap-2 text-sm';
      labelDel.innerHTML = `
        <input type="checkbox" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500"
               name="delete_media_ids[]" value="${media.id}">
        <span class="text-gray-700">Eliminar #${media.id}</span>
      `;
      delContainer.prepend(labelDel);
    }
  }

  async function uploadFileAjax(file, progressCb) {
    const fd = new FormData();
    fd.append('images[]', file);
    // No mandamos "ajax_media" porque tu storeAjax procesa directamente

    const res = await fetch(ajaxUrl, {
      method: 'POST',
      headers: {
        'X-Requested-With': 'XMLHttpRequest',
        'X-CSRF-TOKEN': csrf,
        'Accept': 'application/json',
      },
      body: fd,
      credentials: 'same-origin',
    });

    if (!res.ok) {
      let msg = `Error HTTP ${res.status}`;
      try { const j = await res.json(); if (j.message) msg = j.message; } catch {}
      throw new Error(msg);
    }

    progressCb && progressCb(100);

    return res.json();
  }

  // Blindaje: no enviar archivos al guardar el form principal
  document.addEventListener('DOMContentLoaded', () => {
    const form = document.querySelector('form'); // el form del producto
    const fi   = document.getElementById('nlx-input');

    form?.addEventListener('submit', () => {
      if (!fi) return;
      fi.value = '';
      fi.removeAttribute('name');
      fi.setAttribute('disabled', 'disabled');
      setTimeout(() => fi.removeAttribute('disabled'), 0);
    });
  });

  async function addFilesAjax(fileList) {
    if (!canAjax) {
      toast('Guarda el producto primero para subir imágenes vía AJAX.', true);
      return;
    }
    const valid = [...fileList].filter(fileValid);
    if (!valid.length) return;

    if ($count) $count.textContent = String(Number($count.textContent || 0) + valid.length);

    for (const file of valid) {
      const { card, bar } = renderUploadingCard(file);
      let fakeProg = 0;
      const t = setInterval(()=> {
        fakeProg = Math.min(95, fakeProg + 5);
        bar.style.width = fakeProg + '%';
      }, 120);

      try {
        const json = await uploadFileAjax(file, (p)=>{ bar.style.width = p+'%'; });
        clearInterval(t);
        bar.style.width = '100%';

        (json.uploaded || []).forEach(m => injectMediaToRightPanel(m));

        setTimeout(()=> card.remove(), 400);
        toast('Imagen subida.');
      } catch (err) {
        clearInterval(t);
        bar.classList.remove('bg-indigo-500');
        bar.classList.add('bg-red-500');
        toast(err.message || 'Error al subir.', true);
      }
    }

    if ($input) $input.value = '';
  }

  // Drag & drop / click
  ['dragenter','dragover'].forEach(evt =>
    $drop.addEventListener(evt, e => { e.preventDefault(); e.stopPropagation(); $drop.classList.add('ring-2','ring-blue-400'); })
  );
  ['dragleave','dragend','drop'].forEach(evt =>
    $drop.addEventListener(evt, e => { e.preventDefault(); e.stopPropagation(); $drop.classList.remove('ring-2','ring-blue-400'); })
  );
  $drop.addEventListener('drop', e => { addFilesAjax(e.dataTransfer.files); });

  $browse?.addEventListener('click', () => $input.click());
  $drop.addEventListener('click', (e) => { if (e.target === $drop) $input.click(); });
  $input.addEventListener('change', () => addFilesAjax($input.files));

  if (!canAjax && $hint) {
    $hint.classList.remove('text-gray-500');
    $hint.classList.add('text-amber-700');
  }
})();
</script>
@endpush

@push('scripts')
<script>
// Exponer rates global (si otra vista lo requiere)
window.currencyRates = @json($currencyRates);
</script>
@endpush
