{{-- resources/views/zapatera/admin/products/partials/media_tagger_js.blade.php --}}
<script>
    // Define el componente como función GLOBAL antes de que Alpine lo use
    window.mediaTagger = window.mediaTagger || function mediaTagger() {
      return {
        show: false,
        submitting: false,
        form: { media_id: null, is_primary: false, attribute_value_ids: [] },
        updateUrl: '',

        open({ id, is_primary=false, selected=[] }) {
          if (!window.UPDATE_URL_TPL) {
            this.toast('Guarda el producto primero para etiquetar imágenes.', true);
            return;
          }
          this.show = true;
          this.form.media_id = id;
          this.form.is_primary = !!is_primary;
          this.form.attribute_value_ids = Array.from(new Set((selected || []).map(Number)));
          this.updateUrl = window.UPDATE_URL_TPL.replace('___MEDIA___', String(id));

          queueMicrotask(() => {
            const sel = this.$refs?.select;
            if (!sel) return;
            [...sel.options].forEach(o => { o.selected = this.form.attribute_value_ids.includes(Number(o.value)); });
            sel.onchange = () => {
              const vals = [...sel.selectedOptions].map(o => Number(o.value));
              this.form.attribute_value_ids = Array.from(new Set(vals));
            };
          });
        },

        async submitAjax(ev) {
          const formEl = (ev && ev.target) ? ev.target : this.$refs?.ajaxForm;
          if (!formEl || this.submitting) return;
          this.submitting = true;

          try {
            const fd = new FormData(formEl);

            const sel = this.$refs?.select;
            if (sel) {
              const vals = [...sel.selectedOptions].map(o => Number(o.value));
              this.form.attribute_value_ids = Array.from(new Set(vals));
            }
            fd.delete('attribute_value_ids[]');
            this.form.attribute_value_ids.forEach(v => fd.append('attribute_value_ids[]', v));

            const res = await fetch(this.updateUrl, {
              method: 'POST', // POST con _method=PUT
              headers: { 'Accept': 'application/json', 'X-Requested-With': 'XMLHttpRequest' },
              body: fd,
              credentials: 'same-origin'
            });

            if (!res.ok) {
              let msg = 'Error al actualizar.';
              try { const j = await res.json(); msg = j.message || msg; } catch {}
              throw new Error(msg);
            }

            const json = await res.json();
            this.updateChips(json.media.id, json.media.chips);
            if (json.product && json.product.primary_media_id) this.updatePrimaryRadio(json.product.primary_media_id);

            this.close();
            this.toast(json.message || 'Actualizado.');
          } catch (err) {
            console.error(err);
            this.toast(err.message || 'No se pudo guardar', true);
          } finally {
            this.submitting = false;
          }
        },

        updateChips(mediaId, chips) {
          const cont = document.querySelector(`.media-chips[data-media-id="${mediaId}"]`);
          if (!cont) return;
          cont.innerHTML = '';
          if (!Array.isArray(chips)) return;
          chips.forEach(chip => {
            const span = document.createElement('span');
            span.className = 'px-2 py-0.5 rounded-full bg-slate-100 border text-[10px]';
            span.textContent = `${chip.attribute ?? 'Attr'}: ${chip.value ?? '—'}`;
            cont.appendChild(span);
          });
        },

        updatePrimaryRadio(primaryId) {
          document.querySelectorAll('input[name="primary_media_id"]').forEach(r => { r.checked = false; });
          const radio = document.getElementById(`primary_media_${primaryId}`);
          if (radio) radio.checked = true;
        },

        close(){ this.show = false; },

        toast(msg, isErr=false) {
          const el = document.createElement('div');
          el.textContent = msg;
          el.className = `fixed bottom-4 left-1/2 -translate-x-1/2 px-3 py-2 rounded-lg text-white ${isErr ? 'bg-red-600' : 'bg-emerald-600'}`;
          el.style.zIndex = 9999;
          document.body.appendChild(el);
          setTimeout(() => el.remove(), 1800);
        }
      }
    };
    </script>
