{{-- resources/views/zapatera/admin/products/form.blade.php --}}
@csrf

@php
  use App\Models\Product;

  // Monedas para UI de costo/precio
  $currencies = \App\Models\Currency::orderByDesc('is_primary')->orderBy('code')->get();
  $defaultCurrency = optional($currencies->firstWhere('is_primary',true))->id;
  $currencyRates = $currencies->map(fn($c)=>[
    'id' => $c->id,
    'code' => $c->code,
    'rate' => (float)$c->rate_to_primary,
    'is_primary' => (bool)$c->is_primary,
  ]);

  // AJAX upload habilitado sólo si el producto existe
  $canAjaxUpload = isset($product) && $product instanceof Product && $product->exists;
  $ajaxUploadUrl = $canAjaxUpload
      ? route('zapatera.admin.products.media.store.ajax', $product)
      : null;

  // Plantilla de URL para actualizar media (modal Etiquetar)
  $updateUrlTpl = null;
  if ($canAjaxUpload) {
      $updateUrlTpl = route('zapatera.admin.products.media.update', [
          'product' => $product->getKey(),
          'media'   => '___MEDIA___',
      ]);
  }
@endphp

<div class="grid grid-cols-1 md:grid-cols-4 gap-3">
  <div>
    <label class="block text-sm font-medium text-gray-700">Nombre</label>
    <input name="name" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" value="{{ old('name', $product->name ?? '') }}" required>
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700">Categoría</label>
    <select name="category_id" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" required>
      <option value="">Seleccione</option>
      @foreach($categories as $c)
        <option value="{{ $c->id }}" @selected(old('category_id', $product->category_id ?? '')==$c->id)>{{ $c->name }}</option>
      @endforeach
    </select>
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700">SKU</label>
    <input name="sku" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" value="{{ old('sku', $product->sku ?? '') }}" required>
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700">Código de barra</label>

    <div class="mt-1 flex gap-2 items-stretch">
      <input type="text"
             name="barcode"
             id="barcode-input"
             class="block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500"
             value="{{ old('barcode', $product->barcode ?? '') }}"
             placeholder="Ej. 7501031311309 / interno">

      <a class="inline-flex items-center gap-2 rounded-lg border border-blue-500 text-blue-600 px-3 text-sm hover:bg-blue-50 {{ empty($product->barcode)?'hidden':'' }}"
         href="{{ isset($product->barcode) ? route('zapatera.admin.barcode.thermal', ['code'=>$product->barcode]) : '#' }}"
         target="_blank" id="barcode-thermal">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/></svg>
        HTML
      </a>
      <a class="inline-flex items-center gap-2 rounded-lg border border-gray-600 text-gray-700 px-3 text-sm hover:bg-gray-50 {{ empty($product->barcode)?'hidden':'' }}"
         href="{{ isset($product->barcode) ? route('zapatera.admin.barcode.zplOne', ['code'=>$product->barcode]) : '#' }}"
         target="_blank" id="barcode-zpl">
         ZPL
      </a>
    </div>

    <div class="mt-1 text-xs text-gray-500">Puedes dejarlo vacío y asignarlo más tarde.</div>

    <div id="barcode-preview-wrap" class="mt-2 hidden rounded-lg border border-gray-200 overflow-hidden">
      <div class="px-2 py-1 flex items-center justify-between bg-gray-50">
        <strong class="text-xs">Vista previa del código</strong>
        <span class="text-xs text-gray-500" id="barcode-preview-hint"></span>
      </div>
      <div class="p-2">
        <div id="barcode-preview-ajax" class="text-center"></div>
      </div>
    </div>
  </div>
</div>

<div class="mt-3">
  <label class="block text-sm font-medium text-gray-700">Descripción</label>
  <textarea name="description" class="mt-1 block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500" rows="3">{{ old('description', $product->description ?? '') }}</textarea>
</div>

<div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4 items-start">
  <div class="space-y-4">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 items-end">
      <div>
        <label class="block text-sm font-medium text-gray-700">Costo</label>
        <div class="mt-1 flex gap-2">
          <input id="cost" type="number" step="0.01" name="cost" class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500"
                 value="{{ old('cost', $product->cost ?? 0) }}">
          <select id="cost_currency_id" name="cost_currency_id" class="w-28 rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500">
            @foreach($currencies as $c)
              <option value="{{ $c->id }}"
                      @selected(old('cost_currency_id', $product->cost_currency_id ?? $defaultCurrency)==$c->id)>
                {{ $c->code }}
              </option>
            @endforeach
          </select>
        </div>
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-700">Precio base</label>
        <div class="mt-1 flex gap-2">
          <input id="base_price" type="number" step="0.01" name="base_price" class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500"
                 value="{{ old('base_price', $product->base_price ?? 0) }}" required>
          <select id="base_price_currency_id" name="base_price_currency_id" class="w-28 rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500">
            @foreach($currencies as $c)
              <option value="{{ $c->id }}"
                      @selected(old('base_price_currency_id', $product->base_price_currency_id ?? $defaultCurrency)==$c->id)>
                {{ $c->code }}
              </option>
            @endforeach
          </select>
        </div>
      </div>

      <div class="md:col-span-2">
        <label class="block text-sm font-medium text-gray-700">Ganancia</label>
        <div id="profit-text" class="mt-1 rounded-lg border border-gray-200 bg-gray-50 p-2 text-sm">—</div>
      </div>
    </div>
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700">Subcategorías (Atributos)</label>

    <div class="mt-1 rounded-lg border border-gray-200 p-3 max-h-72 sm:max-h-80 overflow-auto">
      <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
        @foreach($attributes as $attr)
          <fieldset class="rounded-md border border-gray-100 p-3">
            <legend class="px-1 text-xs font-semibold text-gray-700">{{ $attr->name }}</legend>

            <div class="mt-2 grid gap-2 [grid-template-columns:repeat(auto-fit,minmax(120px,1fr))]">
              @foreach($attr->values as $val)
                @php
                  $checked = in_array($val->id, old('attribute_values', $selectedAttributeValues ?? []));
                @endphp
                <label class="inline-flex items-center gap-2 rounded-md border border-gray-200 bg-white px-2.5 py-1.5 text-sm hover:bg-slate-50">
                  <input
                    class="rounded border-gray-300 text-blue-600 focus:ring-blue-500"
                    type="checkbox"
                    name="attribute_values[]"
                    value="{{ $val->id }}"
                    {{ $checked ? 'checked' : '' }}>
                  <span class="truncate text-gray-700">{{ $val->value }}</span>
                </label>
              @endforeach
            </div>
          </fieldset>
        @endforeach
      </div>
    </div>

    <div class="mt-1 text-xs text-gray-500">
      Un producto tiene 1 categoría principal y múltiples subcategorías.
    </div>
  </div>
</div>

{{-- ============================
     BLOQUE DE IMÁGENES + MODAL
============================ --}}
   @php
   //use App\Models\Product;
   $canAjaxUpload = isset($product) && $product instanceof Product && $product->exists;
   $ajaxUploadUrl = $canAjaxUpload
       ? route('zapatera.admin.products.media.store.ajax', $product)
       : null;

   $updateUrlTpl = null;
   if ($canAjaxUpload) {
       $updateUrlTpl = route('zapatera.admin.products.media.update', [
           'product' => $product->getKey(),
           'media'   => '___MEDIA___',
       ]);
   }
 @endphp

 {{-- Renderizamos el contenedor Alpine SOLO si hay producto guardado --}}
 @if($canAjaxUpload)
 @include('zapatera.admin.products.partials.media_tagger_js')
   <div
     x-data="mediaTagger()"
     x-cloak
     class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4"
     data-can-ajax="1"
     data-ajax-url="{{ $ajaxUploadUrl }}"
   >
     <div>
       <label class="block text-sm font-medium text-gray-700">Imágenes</label>

       <div id="nlx-uploader"
            class="mt-1 relative rounded-2xl border-2 border-dashed border-gray-300 bg-gray-50 p-6 text-center">
         <div class="flex flex-col items-center gap-2">
           <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h10a4 4 0 004-4M7 10l5-5m0 0l5 5m-5-5v12"/></svg>
           <div class="font-medium text-gray-700">Arrastra tus imágenes aquí</div>
           <div class="text-xs text-gray-500">o</div>
           <button type="button" id="nlx-browse" class="inline-flex items-center justify-center rounded-lg border border-blue-500 px-3 py-1.5 text-sm text-blue-600 hover:bg-blue-50">
             Elegir archivos
           </button>
           <div class="text-xs text-gray-500">
             JPG, PNG, WEBP · Máx <span id="nlx-max-mb">5</span> MB c/u · Múltiples permitidas
           </div>

           <div class="mt-1 text-xs">
             <span class="inline-flex items-center gap-1 rounded-full bg-gray-200 px-2 py-0.5 text-gray-700">
               <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h18M3 12h18M3 17h18"/></svg>
               <span id="nlx-count">0</span> seleccionadas
             </span>
           </div>
         </div>

         <input id="nlx-input" type="file" accept="image/*" multiple class="hidden" data-ajax-only>
       </div>

       {{-- Previews locales durante la subida (se limpian automáticamente) --}}
       <div id="nlx-previews" class="mt-2 grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-2"></div>

       <div class="mt-2 text-xs text-gray-500">
         Puedes subir varias imágenes. Luego, debajo, eliges la principal o eliminas existentes.
       </div>
     </div>

     {{-- Panel derecho con media existente (solo visible si $media existe) --}}
     @isset($media)
       <div class="space-y-4">
         <div>
           <label class="block text-sm font-medium text-gray-700">Seleccionar imagen principal</label>
           <div class="mt-1 flex flex-wrap gap-3">
             @foreach($media as $m)
               @php
                 $raw = trim($m->path ?? '');
                 $url = null;
                 if ($raw !== '') {
                   if (preg_match('~^https?://~i', $raw)) $url = $raw;
                   elseif (str_starts_with($raw, 'storage/')) $url = asset($raw);
                   elseif (\Storage::disk('public')->exists($raw)) $url = \Storage::url($raw);
                   elseif (file_exists(public_path($raw))) $url = asset($raw);
                 }
                 $url = $url ?: asset('img/placeholder_zapato_detalle.svg');
                 $selectedIds = ($m->relationLoaded('attributeValues') ? $m->attributeValues->pluck('id')->all() : []);
                 $chips = $m->attributes_cache;
                 if (!is_array($chips)) { $chips = json_decode($chips ?? '', true) ?: []; }
               @endphp

               <div class="flex flex-col items-center border rounded-xl p-2 media-card" data-media-id="{{ $m->id }}">
                 <img src="{{ $url }}" data-enlargeable class="h-[90px] w-[120px] object-cover rounded cursor-zoom-in" alt="imagen">

                 <div class="mt-3 flex items-center justify-center gap-2 media-primary-wrap">
                   <input id="primary_media_{{ $m->id }}"
                          type="radio"
                          name="primary_media_id"
                          class="h-4 w-4 text-indigo-600 focus:ring-indigo-500"
                          value="{{ $m->id }}"
                          @checked($m->is_primary)>
                   <label for="primary_media_{{ $m->id }}" class="text-sm text-gray-700">
                     Marcar como principal
                   </label>
                 </div>

                 <small class="mt-1 text-gray-500">#{{ $m->id }}</small>

                 <button type="button"
                         class="mt-1 text-xs text-indigo-600 hover:underline"
                         @click="open({ id: {{ $m->id }}, is_primary: {{ $m->is_primary ? 'true' : 'false' }}, selected: @js($selectedIds) })">
                   Etiquetar
                 </button>

                 <div class="mt-2 flex flex-wrap justify-center gap-1 media-chips" data-media-id="{{ $m->id }}">
                   @foreach($chips as $chip)
                     <span class="px-2 py-0.5 rounded-full bg-slate-100 border text-[10px]">
                       {{ $chip['attribute'] ?? 'Attr' }}: {{ $chip['value'] ?? '—' }}
                     </span>
                   @endforeach
                 </div>
               </div>
             @endforeach
           </div>
         </div>

         <div>
           <label class="block text-sm font-medium text-gray-700">Eliminar imágenes</label>
           <div class="mt-1 flex flex-wrap gap-4">
             @foreach($media as $m)
               <label class="inline-flex items-center gap-2 text-sm">
                 <input type="checkbox" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500" name="delete_media_ids[]" value="{{ $m->id }}">
                 <span class="text-gray-700">Eliminar #{{ $m->id }}</span>
               </label>
             @endforeach
           </div>
           <div class="mt-1 text-xs text-gray-500">Marca las imágenes a eliminar y guarda para aplicar cambios.</div>
         </div>
       </div>
     @endisset

     {{-- ===== Modal teletransportado al <body> para evitar forms anidados ===== --}}
     <template x-teleport="body">
       <div x-show="show" x-transition.opacity
            class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/50">
         <div @click.outside="close()" class="w-full max-w-2xl rounded-2xl bg-white shadow-xl border">
           <div class="flex items-center justify-between px-4 py-3 border-b">
             <h3 class="text-base font-semibold text-slate-800">
               Etiquetar imagen <span class="text-slate-500">#<span x-text="form.media_id"></span></span>
             </h3>
             <button type="button" class="text-slate-500 hover:text-slate-800" @click="close()">✕</button>
           </div>

           <form x-ref="ajaxForm" :action="updateUrl" method="POST" class="p-4 space-y-4" @submit.prevent.stop="submitAjax($event)">
             <input type="hidden" name="_token" value="{{ csrf_token() }}">
             <input type="hidden" name="_method" value="PUT">
             <input type="hidden" name="is_primary" :value="form.is_primary ? 1 : 0">

             <div class="flex items-center gap-2">
               <label class="inline-flex items-center gap-2">
                 <input type="checkbox" class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500" x-model="form.is_primary" @keydown.enter.prevent>
                 <span class="text-sm text-slate-700">Marcar como principal</span>
               </label>
             </div>

             <div>
               <label class="block text-sm font-medium text-slate-700 mb-1">Atributos de la foto</label>
               <select multiple x-ref="select" class="w-full rounded-xl border-slate-300 focus:ring-indigo-500 focus:border-indigo-500" @keydown.enter.prevent>
                 @foreach($attributes as $attribute)
                   <optgroup label="{{ $attribute->name }}">
                     @foreach($attribute->values as $value)
                       <option value="{{ $value->id }}">{{ $value->name ?? $value->value }}</option>
                     @endforeach
                   </optgroup>
                 @endforeach
               </select>

               <template x-for="vid in form.attribute_value_ids" :key="vid">
                 <input type="hidden" name="attribute_value_ids[]" :value="vid">
               </template>

               <p class="text-xs text-slate-500 mt-1">Ej.: Color = Rojo, Talla = 42.</p>
             </div>

             <div class="flex items-center justify-end gap-2 pt-2 border-t">
               <button type="button" @click="close()" class="px-3 py-1.5 rounded-lg border">Cancelar</button>
               <button type="submit" class="px-4 py-1.5 rounded-lg bg-indigo-600 text-white" :disabled="submitting">
                 <span x-show="!submitting">Guardar</span>
                 <span x-show="submitting">Guardando…</span>
               </button>
             </div>
           </form>
         </div>
       </div>
     </template>
   </div>

<script>
    window.UPDATE_URL_TPL ??= @json($updateUrlTpl);
</script>
 @else
   {{-- Sin producto: no mostramos uploader ni modal --}}
 @endif


{{-- ===== Botones del formulario principal ===== --}}
<div class="mt-4 flex items-center gap-2">
  <button type="submit"
          class="inline-flex items-center justify-center rounded-lg bg-blue-600 px-4 py-2 text-white hover:bg-blue-700">
    Guardar
  </button>
  <a href="{{ route('zapatera.admin.products.index') }}"
     class="inline-flex items-center justify-center rounded-lg border border-gray-300 px-4 py-2 text-gray-700 hover:bg-gray-50">
    Cancelar
  </a>
</div>

{{-- PARTIALS --}}
@include('zapatera.admin.products.partials.lightbox')
@include('zapatera.admin.products.partials.scripts')
