@push('styles')
<style>
/* Miniatura 120x90 exacta */
td.nlx-td-img { width: 120px; max-width: 120px; }
.nlx-thumb-main {
    width: 120px; height: 90px; object-fit: cover;
    display:block; background:#fff; border-radius:.25rem;
    border:1px solid #e5e7eb;
}
#galleryModalBody .amz-close {
    display: none !important;
  }
</style>
@endpush
<x-admin-layout title="Productos - Listado">
    <x-slot:header>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-xl font-semibold text-gray-900">Productos</h1>
                <p class="text-sm text-gray-500">Gestiona los productos de tu inventario.</p>
            </div>
            {{-- Badge de roles del usuario (opcional) --}}
            <x-user-role-badges />
        </div>
    </x-slot:header>


    {{-- CONTENIDO PRINCIPAL --}}
    <section>
        <div class="w-full py-4">
            <div class="d-flex align-items-center justify-content-between mb-3">
                <h5 class="mb-0">Listado de productos</h5>

            </div>

            {{-- Filtros --}}
            <form method="GET" action="{{ route('zapatera.admin.products.index') }}"
                    class="grid grid-cols-1 md:grid-cols-12 gap-3 mb-4 items-end">

                @php
                    $hasFilters = request()->filled('name') || request()->filled('category_id');
                @endphp
                {{-- Buscar por nombre / SKU / categoría --}}
                <div class="md:col-span-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                    Buscar
                    </label>
                    <input type="text" name="name"
                        class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                                focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                        placeholder="Buscar por nombre, SKU o categoría"
                        value="{{ request('name') }}">
                </div>

                {{-- Categoría --}}
                <div class="md:col-span-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                    Categoría
                    </label>
                    <select name="category_id"
                            class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                                bg-white focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                    <option value="">— Todas las categorías —</option>
                    @foreach($categories as $c)
                        <option value="{{ $c->id }}" @selected(request('category_id')==$c->id)>
                        {{ $c->name }}
                        </option>
                    @endforeach
                    </select>
                </div>

                {{-- Botones --}}
                <div class="md:col-span-4 flex flex-wrap gap-2">
                    <button class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                                rounded-lg text-sm font-semibold text-white
                                bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500">
                    Filtrar
                    </button>
                    @if($hasFilters)
                    <a href="{{ route('zapatera.admin.products.index') }}"
                    class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-indigo-700 bg-indigo-50 border border-indigo-200
                            hover:bg-indigo-100">
                    Limpiar
                    </a>
                    @endif
                    <a href="{{ route('zapatera.admin.products.create') }}"
                    class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                        rounded-lg text-sm font-semibold text-white bg-emerald-600 hover:bg-emerald-700">
                        + Nuevo producto</a>
                </div>
            </form>


            <div class="w-full overflow-x-auto">
                <table class="w-full min-w-full table-auto align-middle">
                <thead>
                    <tr>
                    <th style="width:120px">Imagen</th>
                    <th>Nombre</th>
                    <th class="hidden sm:table-cell">Código</th>
                    <th class="hidden sm:table-cell">Categoría</th>
                    <th class="text-end">Costo</th>
                    <th class="text-end">Precio Base</th>
                    <th class="text-end" style="width:160px"></th>
                    </tr>
                </thead>

                <tbody>
                @forelse($products as $p)
                    @php

                        $toUrl = function($path) {
                            $raw = trim($path ?? '');
                            if ($raw === '') return null;
                            if (preg_match('~^https?://~i',$raw)) return $raw;
                            if (str_starts_with($raw,'public/storage/')) return asset(substr($raw,7));
                            if (str_starts_with($raw,'storage/')) return asset($raw);
                            if (\Storage::disk('public')->exists($raw)) return \Storage::url($raw);
                            if (file_exists(public_path($raw))) return asset($raw);
                            return null;
                        };

                        $media    = collect($p->media ?? []);
                        $primary  = $media->firstWhere('is_primary', true) ?? $media->first();
                        $others   = $media->filter(fn($m)=> $primary ? $m->id !== $primary->id : true);
                        $ordered  = collect($primary ? [$primary] : [])->merge($others);

                        $imgUrls  = $ordered->map(fn($m)=> $toUrl($m->path))->filter()->values();

                        $placeholder = asset('img/placeholder_zapato_detalle.svg');
                        $mainUrl     = $imgUrls->first() ?: $placeholder;

                        /** Hay galería “real” si:
                        * - hay >1 imagen, o
                        * - hay 1 imagen pero NO es el placeholder
                        */
                        $hasRealGallery = $imgUrls->count() > 1
                            || ($imgUrls->count() === 1 && !\Illuminate\Support\Str::contains($imgUrls->first(), 'placeholder_zapato_detalle.svg'));
                    @endphp


                    <tr class="hover:bg-gray-50">
                        <td class="nlx-td-img shrink-0">
                            @if($hasRealGallery)
                                <a href="{{ route('zapatera.admin.products.gallery', ['product'=>$p->id, 'i'=>0]) }}"
                                    class="d-inline-block" aria-label="Ver galería del producto">
                                <img src="{{ $mainUrl }}" class="nlx-thumb-main img-thumbnail" alt="{{ $p->name }}" loading="lazy">
                                </a>
                            @else
                                <img src="{{ $mainUrl }}" class="nlx-thumb-main img-thumbnail" alt="{{ $p->name }}" loading="lazy">
                            @endif
                        </td>


                        {{-- Nombre + SKU (badge pequeño debajo) --}}
                        <td class="fw-semibold align-middle min-w-0">
                            <div class="text-gray-900">{{ $p->name }}</div>
                            @if($p->sku)
                            <div class="mt-1 hidden sm:block">
                                {{--  <span class="inline-flex items-center rounded-full bg-gray-100 text-gray-700 border border-gray-200 px-2 py-0.5 text-[11px] font-medium">  --}}
                                <span class="inline-flex items-center rounded-full bg-indigo-50 text-indigo-700 border border-indigo-200 px-2 py-0.5 text-[11px] font-medium">
                                    {{ $p->sku }}
                                </span>
                            </div>
                            @endif
                        </td>

                        <td class="hidden sm:table-cell">
                            @if($p->barcode)
                            <span class="badge text-bg-light">{{ $p->barcode }}</span>
                            @endif
                        </td>

                        <td class="hidden sm:table-cell">{{ optional($p->category)->name }}</td>

                        {{-- Costo --}}
                        <td class="text-end tabular-nums shrink-0">
                            {{-- móvil: sin miles ni decimales --}}
                            <span class="sm:hidden">${{ (int) ($p->cost ?? 0) }}</span>
                            {{-- desde sm: tu formato normal --}}
                            <span class="hidden sm:inline">${{ number_format((float) ($p->cost ?? 0), 2) }}</span>
                        </td>

                        {{-- Precio base --}}
                        <td class="text-end tabular-nums shrink-0">
                            <span class="sm:hidden">${{ (int) ($p->base_price ?? 0) }}</span>
                            <span class="hidden sm:inline">${{ number_format((float) ($p->base_price ?? 0), 2) }}</span>
                        </td>

                        <td class="text-right whitespace-nowrap shrink-0">
                            <a href="{{ route('zapatera.admin.products.edit',$p) }}"
                                class="inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold
                                        bg-white border border-gray-300 text-gray-700 hover:bg-gray-50">
                                Editar
                            </a>

                            <form action="{{ route('zapatera.admin.products.destroy',$p) }}" method="post"
                                    class="inline-block ml-2"
                                    onsubmit="return confirm('¿Eliminar producto {{ $p->name }}? Esta acción no se puede deshacer.');">
                                @csrf
                                @method('DELETE')
                                <button
                                class="inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold
                                        bg-rose-50 text-rose-700 border border-rose-200 hover:bg-rose-100">
                                Eliminar
                                </button>
                            </form>
                        </td>

                    </tr>
                @empty
                    <tr>
                    <td colspan="8" class="text-center text-muted py-4">Sin resultados</td>
                    </tr>
                @endforelse
                </tbody>
                </table>
            </div>

            {{-- Con $products (paginador) --}}
            {{--  <x-ui.pagination :paginator="$products" />  --}}

            {{-- Mostrar más páginas alrededor de la actual --}}
            {{--  <x-ui.per-page class="order-1" />  --}}
            {{--  <x-ui.pagination :paginator="$products" :window="2" />  --}}

            {{-- Ocultar el resumen "Mostrando X–Y de Z" --}}
            {{--  <x-ui.pagination :paginator="$products" :show-summary="false" />  --}}

            {{-- paginador con selector por pagina en el centro ejemplo 1 --}}
            {{--  <x-ui.pagination :paginator="$products">
                <x-slot:middle>
                  <x-ui.per-page />
                </x-slot:middle>
            </x-ui.pagination>  --}}

            {{-- paginador con selector por pagina en el centro --}}
            <x-ui.pagination :paginator="$products" :window="2" :show-summary="false">
                <x-slot:middle>
                  <x-ui.per-page class="hidden sm:inline-flex" />
                </x-slot:middle>
            </x-ui.pagination>

        </div>
    </section>

    {{-- Modal de Galería (Tailwind + Alpine) --}}
    <div
        x-data="galleryModal()"
        x-init="init()"
        x-show="isOpen"
        x-transition.opacity
        @keydown.escape.window="close()"
        @gallery:open.window="open($event.detail)"
        class="fixed inset-0 z-50 flex items-center justify-center bg-black/50"
        style="display:none;"
        >
            <div
            class="relative w-[95vw] max-w-7xl rounded-lg bg-white shadow-xl"
            @click.self="close()"
            >
            <button
                @click="close()"
                class="absolute right-2 top-2 inline-flex h-8 w-8 items-center justify-center rounded-full bg-gray-100 text-gray-600 hover:bg-gray-200"
                aria-label="Cerrar"
            >✕</button>

            <div class="p-0" x-ref="body" id="galleryModalBody">
                {{-- Contenido AJAX aquí --}}
            </div>
        </div>
    </div>


    @push('scripts')
<script>
// Intercepta clic normal para abrir modal-embed; respeta Ctrl+Click/rueda para página completa
document.addEventListener('click', (e) => {
  const a = e.target.closest('a[aria-label="Ver galería del producto"]');
  if (!a) return;

  // Si el usuario quiere nueva pestaña (Ctrl/Meta o rueda), NO interceptamos
  if (e.ctrlKey || e.metaKey || e.shiftKey || e.button === 1) return;

  e.preventDefault();
  window.dispatchEvent(new CustomEvent('gallery:open', {
    detail: { url: a.href }
  }));
});

// Componente Alpine del modal
function galleryModal() {
  return {
    isOpen: false,
    bodyEl: null,

    init() { this.bodyEl = this.$refs.body; },

    open({ url }) {
      this.isOpen = true;
      this._renderSpinner();

      // Carga la parcial probada con ?embed=1
      const u = new URL(url, window.location.origin);
      u.searchParams.set('embed', '1');

      fetch(u.toString(), { headers: { 'X-Requested-With': 'XMLHttpRequest' } })
        .then(res => {
          if (!res.ok) throw new Error('HTTP ' + res.status);
          return res.text();
        })
        .then(html => {
          this.bodyEl.innerHTML = html;
          this._wireGallery(this.bodyEl);
        })
        .catch(err => {
          // Fallback: si falla el fetch, navega a la página completa
          window.location.href = url;
        });
    },

    close() {
      this.isOpen = false;
      this.bodyEl.innerHTML = '';
    },

    _renderSpinner() {
      this.bodyEl.innerHTML = `
        <div class="flex min-h-[60vh] items-center justify-center p-6">
          <div class="text-center">
            <div class="mx-auto mb-2 inline-block h-6 w-6 animate-spin rounded-full border-2 border-gray-300 border-t-indigo-600"></div>
            <div class="text-sm text-gray-500">Cargando galería...</div>
          </div>
        </div>
      `;
    },

    // Conecta eventos dentro del HTML cargado
    _wireGallery(root) {
      // Tu parcial usa CLASES .amz-grid y .amz-thumbs
      const grid   = root.querySelector('.amz-grid');
      const main   = root.querySelector('#amz-main');
      const thumbs = root.querySelector('.amz-thumbs');

      if (!grid || !main || !thumbs) return;

      // Construye items desde la propia parcial (ya trae <img> en thumbs)
      // Preferimos la fuente de verdad del DOM para no depender de data-* opcionales
      const itemNodes = thumbs.querySelectorAll('.amz-thumb img, .amz-thumb picture img, .amz-thumb source[srcset]');
      const items = [];
      itemNodes.forEach(node => {
        const src = node.getAttribute('src') || node.getAttribute('srcset') || '';
        if (src) items.push({ url: src });
      });

      // Índice inicial por query 'i' o por data-initial si lo usas
      let idx = 0;
      try {
        const initial = new URLSearchParams(window.location.search).get('i');
        if (initial !== null) idx = Math.max(0, Math.min(items.length - 1, parseInt(initial, 10) || 0));
      } catch(_) {}

      const paint = () => {
        if (!items.length) return;
        idx = (idx + items.length) % items.length;
        main.src = items[idx].url;

        // Resaltar thumb activa con Tailwind ring
        root.querySelectorAll('.amz-thumb').forEach((t, i) => {
            t.classList.toggle('active', i === idx);
        });
      };

      // Click en thumbs
      thumbs.addEventListener('click', (e) => {
        const el = e.target.closest('.amz-thumb');
        if (!el) return;
        const imgs = Array.from(thumbs.querySelectorAll('.amz-thumb'));
        const i = imgs.indexOf(el);
        if (i >= 0) { idx = i; paint(); }
      });

      // Hover (opcional)
      thumbs.addEventListener('mouseover', (e) => {
        const el = e.target.closest('.amz-thumb');
        if (!el) return;
        const imgs = Array.from(thumbs.querySelectorAll('.amz-thumb'));
        const i = imgs.indexOf(el);
        if (i >= 0 && i !== idx) { idx = i; paint(); }
      });

      // Navegación con teclado solo cuando el modal está abierto
      const onKey = (e) => {
        if (!this.isOpen || !items.length) return;
        if (e.key === 'ArrowLeft')  { idx = idx - 1; paint(); }
        if (e.key === 'ArrowRight') { idx = idx + 1; paint(); }
      };
      document.addEventListener('keydown', onKey);

      // Limpieza al cerrar modal
      this.$watch('isOpen', (open) => {
        if (!open) document.removeEventListener('keydown', onKey);
      });

      // Tamaño seguro del principal por si la parcial no lo define
      main.style.maxHeight = '60vh';
      main.style.width = '100%';
      main.style.objectFit = 'contain';

      paint();
    }
  }
}
</script>
@endpush


</x-admin-layout>