<style>
    :root{ --thumb-col: 5%; --gap: 14px; }

    .amz-grid{
      display:grid;
      grid-template-columns: var(--thumb-col) minmax(0,1fr);
      gap: var(--gap);
      min-height: 60vh;
      padding-bottom: 24px; /* espacio inferior */
    }
    .amz-grid.single{ grid-template-columns: minmax(0,1fr); }

    /* Columna de thumbs centrados horizontalmente */
    .amz-thumbs{
      overflow: visible;
      padding:14px 0;
      display:flex;
      flex-direction:column;
      gap:10px;
      align-items:center;     /* ← centra horizontalmente */
      justify-content:flex-start; /* no centramos verticalmente para mantener scroll natural */
      min-width:64px;
    }

    .amz-thumb{
      width:50px; height:50px; border-radius:6px;
      overflow:hidden; background:#fff;
      border:0.5px solid #ccc; /* borde más fino */
      cursor:pointer; display:grid; place-items:center;
      flex:0 0 auto;
    }
    .amz-thumb img{ width:50px; height:50px; object-fit:cover; display:block; }
    .amz-thumb.active{ outline:2px solid #0d6efd; outline-offset:2px; }

    .amz-stage{
      background:#fff; min-height:60vh;
      display:grid; place-items:center; position:relative;
    }
    .amz-stage img#amz-main{
      max-width:95%; max-height:80vh; object-fit:contain;
      user-select:none; -webkit-user-drag:none;
    }

    .amz-head{
      display:flex; align-items:center; justify-content:space-between;
      gap:12px; padding:12px 16px;
    }
    .amz-close{
      background:none; border:none; color:#666;
      font-size:1.5rem; line-height:1; cursor:pointer;
    }
    .amz-close:hover{ color:#000; }

    .amz-meta{ color:#6c757d; font-size:.9rem; }

    @media (max-width: 768px){
      :root{ --thumb-col: 100%; }
      .amz-grid{ grid-template-columns: minmax(0,1fr); }
      .amz-thumbs{ flex-direction:row; justify-content:center; align-items:center; height:auto; }
      .amz-stage img#amz-main{ max-height:60vh; }
    }

    /* Más espacio al área principal y altura mayor */
    #galleryModalBody .amz-grid{
        grid-template-columns: 84px minmax(0,1fr); /* thumbs fijos + main flexible */
        gap: 12px;
        min-height: 70vh;
    }
    #galleryModalBody .amz-thumbs{ min-width:84px; }
    #galleryModalBody .amz-thumb{ width:60px; height:60px; }
    #galleryModalBody .amz-thumb img{ width:60px; height:60px; object-fit:cover; }

    /* La imagen principal puede crecer más alto */
    #galleryModalBody .amz-stage{ min-height:70vh; }
    #galleryModalBody .amz-stage img#amz-main{
        max-width: 98%;
        max-height: 85vh;      /* antes 80vh/60vh */
        width: auto;
        height: auto;
        object-fit: contain;
    }

    /* En móviles seguimos a una columna */
    @media (max-width: 768px){
        #galleryModalBody .amz-grid{
        grid-template-columns: minmax(0,1fr);
        min-height: 60vh;
        }
        #galleryModalBody .amz-stage img#amz-main{ max-height: 70vh; }
    }
  </style>

  @php
  $items = [];
  foreach ($media as $m) {
    $raw = trim($m->path ?? '');
    $url = null;
    if ($raw !== '') {
      if (preg_match('~^https?://~i', $raw)) {
        $url = $raw;
      } elseif (str_starts_with($raw,'public/storage/')) {
        $p = substr($raw,7);
        if (file_exists(public_path($p))) $url = asset($p);
      } elseif (str_starts_with($raw,'storage/')) {
        if (file_exists(public_path($raw))) $url = asset($raw);
      } else {
        if (\Storage::disk('public')->exists($raw)) {
          $url = \Storage::url($raw);
        } elseif (file_exists(public_path($raw))) {
          $url = asset($raw);
        }
      }
    }

    // Solo agregamos a $items si tenemos URL real
    if ($url) {
      $items[] = [
        'id'=>$m->id,
        'url'=>$url,
        'is_primary'=>(bool)$m->is_primary
      ];
    }
  }

  // Si no hay items, ponemos uno solo de placeholder (opcional)
  if (empty($items)) {
    $items[] = [
      'id'=>0,
      'url'=>asset('img/placeholder_zapato_detalle.svg'),
      'is_primary'=>true
    ];
  }
@endphp

<div class="amz-head">
  <div>
    <div class="fw-semibold">{{ $product->name }}</div>
    <div class="amz-meta">
      SKU: {{ $product->sku }}
      @if($product->barcode) · Barcode: {{ $product->barcode }} @endif
    </div>
  </div>
  <button type="button" class="amz-close" data-bs-dismiss="modal" aria-label="Cerrar">&times;</button>
</div>

<div class="amz-grid {{ count($items)<=1 ? 'single' : '' }}"
     id="amz-grid"
     data-items='@json($items)'
     data-initial='{{ $initialIndex }}'>

  @if(count($items)>1)
    <div class="amz-thumbs" id="amz-thumbs">
      @foreach($items as $i => $it)
        @if(!empty($it['url']))
          <div class="amz-thumb {{ $i===$initialIndex ? 'active' : '' }}"
               data-index="{{ $i }}"
               title="#{{ $it['id'] }} {{ $it['is_primary'] ? '(principal)' : '' }}">
            <img src="{{ $it['url'] }}" alt="thumb">
          </div>
        @endif
      @endforeach
    </div>
  @endif

  <div class="amz-stage">
    <img id="amz-main" src="{{ $items[$initialIndex]['url'] ?? asset('img/placeholder_zapato_detalle.svg') }}" alt="imagen">
  </div>
</div>
