@extends('layouts.app')

@section('title', 'Galería - '.$product->name)

@section('content')
<style>
  /* ====== Estilos auto-contenidos (no dependen de push/stack) ====== */
  :root{
    --thumb-col: 10%;
    --gap: 14px;
  }
  .amz-grid{
    display: grid !important;
    grid-template-columns: var(--thumb-col) minmax(0,1fr) !important;
    gap: var(--gap) !important;
    min-height: 60vh !important;
  }
  .amz-grid.single { grid-template-columns: minmax(0,1fr) !important; }

  /* Columna de thumbs */
  .amz-thumbs{
    overflow: auto !important;
    padding-right: 4px !important;
    display: flex !important;
    flex-direction: column !important;
    gap: 8px !important;
    /* Evita que Bootstrap table/row afecte */
    width: 100% !important;
  }
  .amz-thumb{
    width: 50px !important; height: 50px !important;
    border-radius: 6px !important;
    overflow: hidden !important;
    background: #fff !important;
    border: 1px solid #e5e7eb !important;
    cursor: pointer !important;
    display: grid !important; place-items: center !important;
    flex: 0 0 auto !important;
  }
  .amz-thumb img{
    width: 50px !important; height: 50px !important;
    object-fit: cover !important; display:block !important;
  }
  .amz-thumb.active{ outline: 2px solid #0d6efd; outline-offset: 2px; }

  /* Stage derecha */
  .amz-stage{
    border: 1px solid #e5e7eb !important;
    border-radius: 12px !important;
    background: #fff !important;
    min-height: 420px !important; max-height: 76vh !important;
    display: grid !important; place-items: center !important;
    overflow: hidden !important; position: relative !important;
    width: 100% !important;
  }
  .amz-stage img#amz-main{
    max-width: 100% !important; max-height: 100% !important;
    height: auto !important; width: auto !important;
    object-fit: contain !important;
    user-select:none; -webkit-user-drag:none;
  }

  .amz-meta{ color:#6c757d; font-size:.9rem; }

  @media (max-width: 768px){
    :root{ --thumb-col: 100%; }
    .amz-grid{ grid-template-columns: minmax(0,1fr) !important; }
    .amz-thumbs{ flex-direction: row !important; height: 80px !important; }
  }
</style>

@php
  // Resolver URLs como haces en otras vistas
  $items = [];
  foreach ($media as $m) {
    $raw = trim($m->path ?? '');
    $url = null;
    if ($raw !== '') {
      if (preg_match('~^https?://~i', $raw))             $url = $raw;
      elseif (str_starts_with($raw,'public/storage/')) { $p = substr($raw,7); if (file_exists(public_path($p))) $url = asset($p); }
      elseif (str_starts_with($raw,'storage/')) {         if (file_exists(public_path($raw))) $url = asset($raw); }
      else {
        if (\Storage::disk('public')->exists($raw))       $url = \Storage::url($raw);
        elseif (file_exists(public_path($raw)))           $url = asset($raw);
      }
    }
    $items[] = ['id'=>$m->id,'url'=>$url ?: asset('img/placeholder_zapato_detalle.svg'),'is_primary'=>(bool)$m->is_primary];
  }
@endphp

<div class="container-fluid">

  <div class="amz-grid {{ count($items)<=1 ? 'single' : '' }}">
    {{-- Columna izquierda: thumbs 20x20 --}}
    <div id="amz-thumbs" class="amz-thumbs">
      @foreach($items as $i => $it)
        <div class="amz-thumb {{ $i===$initialIndex ? 'active' : '' }}"
             data-index="{{ $i }}"
             title="#{{ $it['id'] }} {{ $it['is_primary'] ? '(principal)' : '' }}">
          <img src="{{ $it['url'] }}" alt="thumb">
        </div>
      @endforeach
    </div>

    {{-- Columna derecha: una sola imagen principal --}}
    <div class="amz-stage">
      <img id="amz-main"
           src="{{ $items[$initialIndex]['url'] ?? asset('img/placeholder_zapato_detalle.svg') }}"
           alt="imagen principal">
    </div>
  </div>
</div>

<script>
(function(){
  const items = @json($items);
  let idx = Number(@json($initialIndex));
  const main   = document.getElementById('amz-main');
  const thumbs = document.querySelectorAll('.amz-thumb');

  function paint(){
    if (!items.length) return;
    main.src = items[idx].url;
    thumbs.forEach((t,i)=> t.classList.toggle('active', i===idx));
  }

  thumbs.forEach(t=>{
    t.addEventListener('click', ()=>{
      const i = parseInt(t.getAttribute('data-index') || '0', 10);
      idx = i; paint();
    });
  });

  // Navegación con teclado (opcional)
  document.addEventListener('keydown', (e)=>{
    if (!items.length) return;
    if (e.key === 'ArrowLeft')  { idx = (idx - 1 + items.length) % items.length; paint(); }
    if (e.key === 'ArrowRight') { idx = (idx + 1) % items.length; paint(); }
  });

  paint();
})();
</script>
@endsection
