<x-admin-layout title="Locales - Listado">
  <x-slot:header>
    <div class="flex items-center justify-between">
      <div>
        <h1 class="text-xl font-semibold text-gray-900">Locales</h1>
        <p class="text-sm text-gray-500">Gestiona tus locales/puntos de venta.</p>
      </div>
      <x-user-role-badges />
    </div>
  </x-slot:header>

  <section class="py-6">
    <div class="max-w-6xl mx-auto px-4">
      @if(session('status'))
        <div class="mb-4 rounded-md bg-green-50 border border-green-200 px-4 py-3 text-green-800">
          {{ session('status') }}
        </div>
      @endif

      {{-- Filtros --}}
      <form method="GET" class="grid grid-cols-1 md:grid-cols-12 gap-3 mb-5 items-end">
        <div class="md:col-span-6">
          <label class="block text-sm font-medium text-gray-700 mb-1">Buscar</label>
          <input type="text" name="q" value="{{ $q }}" placeholder="Nombre, alias o descripción"
                 class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                        focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" />
        </div>

        <div class="md:col-span-6 flex flex-wrap gap-2">
          <button class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                         rounded-lg text-sm font-semibold text-white bg-indigo-600 hover:bg-indigo-700">
            Filtrar
          </button>
          @if(request()->filled('q'))
            <a href="{{ route('zapatera.admin.locals.index') }}"
               class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                      rounded-lg text-sm font-semibold text-indigo-700 bg-indigo-50 border border-indigo-200 hover:bg-indigo-100">
              Limpiar
            </a>
          @endif
          <a href="{{ route('zapatera.admin.locals.create') }}"
             class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                    rounded-lg text-sm font-semibold text-white bg-emerald-600 hover:bg-emerald-700">
            + Nuevo local
          </a>
        </div>
      </form>

      <div class="overflow-x-auto bg-white rounded-xl shadow ring-1 ring-gray-200">
        <table class="min-w-full divide-y divide-gray-200">
          <thead class="bg-gray-50">
            <tr class="text-left text-xs font-semibold text-gray-600 uppercase">
              <th class="px-4 py-3">Alias</th>
              <th class="px-4 py-3">Nombre</th>
              <th class="px-4 py-3">URL</th>
              <th class="px-4 py-3">Flags</th>
              <th class="px-4 py-3 text-right">Acciones</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-200">
            @forelse($locals as $l)
              <tr class="hover:bg-gray-50">
                <td class="px-4 py-3 text-sm font-medium text-gray-900">{{ $l->alias }}</td>
                <td class="px-4 py-3 text-sm text-gray-800">{{ $l->name }}</td>
                <td class="px-4 py-3 text-sm text-indigo-700">
                  @if($l->url)
                    <a href="{{ $l->url }}" target="_blank" class="underline">{{ \Illuminate\Support\Str::limit($l->url, 40) }}</a>
                  @else
                    <span class="text-gray-400">—</span>
                  @endif
                </td>

                <td class="px-4 py-3 text-sm space-x-1">
                    <span class="inline-flex items-center rounded-full bg-gray-100 text-gray-700 border border-gray-200 px-2 py-0.5 text-xs">
                      {{ $l->mode_label }}
                    </span>
                    @if($l->dynamic_pricing)
                      <span class="inline-flex items-center rounded-full bg-indigo-50 text-indigo-700 border border-indigo-200 px-2 py-0.5 text-xs">
                        Dinámica
                      </span>
                    @endif
                </td>

                <td class="px-4 py-3">
                  <div class="flex items-center justify-end gap-2">
                    <a href="{{ route('zapatera.admin.locals.edit', $l) }}"
                       class="inline-flex items-center rounded-md border border-gray-300 px-3 py-1.5 text-sm text-gray-700 hover:bg-gray-50">Editar</a>
                    <form method="POST" action="{{ route('zapatera.admin.locals.destroy', $l) }}"
                          onsubmit="return confirm('¿Eliminar local?')">
                      @csrf @method('DELETE')
                      <button class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-sm text-white hover:bg-red-700">
                        Eliminar
                      </button>
                    </form>
                  </div>
                </td>
              </tr>
            @empty
              <tr><td colspan="5" class="px-4 py-10 text-center text-sm text-gray-500">Sin resultados</td></tr>
            @endforelse
          </tbody>
        </table>
      </div>

      <x-ui.pagination :paginator="$locals" :window="2" :show-summary="false">
        <x-slot:middle>
          <x-ui.per-page class="hidden sm:inline-flex" />
        </x-slot:middle>
      </x-ui.pagination>
    </div>
  </section>
</x-admin-layout>
