@props(['action','method' => 'POST','local'])

<form method="POST" action="{{ $action }}" class="space-y-4">
  @csrf
  @unless(in_array($method, ['POST','GET']))
    @method($method)
  @endunless

  <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
      <label class="block text-sm font-medium text-gray-700">Alias *</label>
      <input name="alias" value="{{ old('alias',$local->alias) }}" required
             class="mt-1 w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500" />
      <x-input-error :messages="$errors->get('alias')" class="mt-1"/>
    </div>

    <div>
      <label class="block text-sm font-medium text-gray-700">Nombre *</label>
      <input name="name" value="{{ old('name',$local->name) }}" required
             class="mt-1 w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500" />
      <x-input-error :messages="$errors->get('name')" class="mt-1"/>
    </div>

    <div class="md:col-span-2">
      <label class="block text-sm font-medium text-gray-700">URL</label>
      <input name="url" value="{{ old('url',$local->url) }}"
             placeholder="https://ejemplo.com"
             class="mt-1 w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500" />
      <x-input-error :messages="$errors->get('url')" class="mt-1"/>
    </div>

    <div class="md:col-span-2">
      <label class="block text-sm font-medium text-gray-700">Descripción</label>
      <textarea name="description" rows="3"
                class="mt-1 w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500"
      >{{ old('description',$local->description) }}</textarea>
      <x-input-error :messages="$errors->get('description')" class="mt-1"/>
    </div>
  </div>

    {{-- Modo de operación --}}
    <div>
        <label class="block text-sm font-medium text-gray-700 mb-1">Modo de operación</label>
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-2">
        @php $mode = old('mode', $local->mode ?? \App\Models\Local::MODE_PRODUCTS); @endphp

        <label class="flex items-center gap-2 rounded-lg border p-3 cursor-pointer
                        {{ $mode==1 ? 'border-indigo-300 bg-indigo-50' : 'border-gray-300 hover:bg-gray-50' }}">
            <input type="radio" name="mode" value="1" class="text-indigo-600" @checked($mode==1)>
            <div>
            <div class="text-sm font-medium text-gray-900">Solo venta</div>
            <div class="text-xs text-gray-500">Solo productos.</div>
            </div>
        </label>

        <label class="flex items-center gap-2 rounded-lg border p-3 cursor-pointer
                        {{ $mode==2 ? 'border-indigo-300 bg-indigo-50' : 'border-gray-300 hover:bg-gray-50' }}">
            <input type="radio" name="mode" value="2" class="text-indigo-600" @checked($mode==2)>
            <div>
            <div class="text-sm font-medium text-gray-900">Solo servicios</div>
            <div class="text-xs text-gray-500">Servicios cobrados manualmente.</div>
            </div>
        </label>

        <label class="flex items-center gap-2 rounded-lg border p-3 cursor-pointer
                        {{ $mode==3 ? 'border-indigo-300 bg-indigo-50' : 'border-gray-300 hover:bg-gray-50' }}">
            <input type="radio" name="mode" value="3" class="text-indigo-600" @checked($mode==3)>
            <div>
            <div class="text-sm font-medium text-gray-900">Mixto</div>
            <div class="text-xs text-gray-500">Productos + servicios.</div>
            </div>
        </label>
        </div>
        <x-input-error :messages="$errors->get('mode')" class="mt-1" />
    </div>

  {{-- Venta dinámica --}}
  <div class="mt-3">
    <label class="inline-flex items-center gap-2">
      <input type="checkbox" name="dynamic_pricing" value="1" class="rounded border-gray-300 text-indigo-600"
             @checked(old('dynamic_pricing', $local->dynamic_pricing ?? false))>
      <span class="text-sm text-gray-700">Activar venta dinámica</span>
    </label>
    <p class="text-xs text-gray-500 mt-1">
      Permite ajustar precio/cantidad al vuelo (p. ej. servicios por tiempo, peso/medida, etc.).
    </p>
    <x-input-error :messages="$errors->get('dynamic_pricing')" class="mt-1" />
  </div>


  <div class="pt-2 flex items-center gap-2">
    <button class="inline-flex items-center justify-center rounded-lg bg-indigo-600 px-4 py-2 text-white hover:bg-indigo-700">
      Guardar
    </button>
    <a href="{{ route('zapatera.admin.locals.index') }}"
       class="inline-flex items-center justify-center rounded-lg border border-gray-300 px-4 py-2 text-gray-700 hover:bg-gray-50">
      Cancelar
    </a>
  </div>
</form>
