{{-- resources/views/admin/inventory/move.blade.php --}}
<x-admin-layout :title="'Inventario – Movimiento'">
    <x-slot name="header">
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-xl font-semibold text-slate-800">Movimiento de inventario</h1>
          <p class="text-sm text-slate-500">Crea entradas/salidas con desglose por atributos.</p>
        </div>
        <a href="{{ route('zapatera.admin.inventory.index') }}"
           class="inline-flex items-center gap-2 rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm text-slate-700 hover:bg-slate-50">
          ← Regresar
        </a>
      </div>
    </x-slot>

    {{-- Mensajes server-side (opcional) --}}
    @if ($errors->any())
      <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 p-3 text-sm text-rose-700">
        <ul class="list-disc pl-5">
          @foreach ($errors->all() as $e)
            <li>{{ $e }}</li>
          @endforeach
        </ul>
      </div>
    @endif

    <form id="batchForm" method="POST" action="">
      @csrf

      {{-- Encabezado del movimiento --}}
      <div class="mb-6 rounded-2xl border border-slate-200 bg-white p-4 shadow-sm">
        <div class="grid grid-cols-12 gap-3">
          {{-- Tipo --}}
          <div class="col-span-6 md:col-span-3">
            <label class="mb-1 block text-xs text-slate-600">Tipo de movimiento</label>
            <select name="type"
                    class="w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 outline-none focus:ring-2 focus:ring-indigo-500">
              <option value="in"  @selected(old('type','in')==='in')>Entrada</option>
              <option value="out" @selected(old('type')==='out')>Salida</option>
            </select>
          </div>

          {{-- Fecha (no menor a hoy) --}}
          <div class="col-span-6 md:col-span-3">
            <label class="mb-1 block text-xs text-slate-600">Fecha</label>
            <input type="date" name="date"
                   value="{{ old('date', now()->format('Y-m-d')) }}"
                   min="{{ now()->format('Y-m-d') }}"
                   class="w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 outline-none focus:ring-2 focus:ring-indigo-500">
          </div>

          {{-- Nota --}}
          <div class="col-span-12 md:col-span-6">
            <label class="mb-1 block text-xs text-slate-600">Nota (opcional)</label>
            <input type="text" name="note" value="{{ old('note') }}"
                   class="w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 outline-none focus:ring-2 focus:ring-indigo-500"
                   placeholder="Ej. Compra a proveedor / Ajuste de stock / Observaciones">
          </div>
        </div>
      </div>

      {{-- Lista de filas (productos) --}}
      <div class="mb-4 rounded-2xl border border-slate-200 bg-white p-4 shadow-sm">
        <div class="mb-3 flex items-center justify-between">
          <h2 class="text-base font-medium text-slate-800">Productos</h2>
          <button type="button" id="addRow"
                  class="rounded-xl bg-indigo-600 px-3 py-2 text-sm font-medium text-white hover:bg-indigo-700">
            + Agregar producto
          </button>
        </div>

        <div id="rows" class="space-y-4">
          {{-- Las filas se insertan aquí --}}
        </div>
      </div>

      {{-- Acciones --}}
      <div class="flex items-center justify-end gap-3">
        {{--  <a href="{{ route('zapatera.admin.inventory.index') }}"
           class="rounded-xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-700 hover:bg-slate-50">Regresar</a>  --}}
        <button type="button" id="addRow2"
                class="rounded-xl bg-indigo-600 px-3 py-2 text-sm font-medium text-white hover:bg-indigo-700">
        + Agregar producto
        </button>
        <button type="submit"
                class="rounded-xl bg-emerald-600 px-4 py-2 text-sm font-semibold text-white hover:bg-emerald-700">
          Guardar movimiento
        </button>
      </div>

      {{-- Template de fila --}}
      <template id="row-template">
        <div class="row-item rounded-xl border border-slate-200 p-3">
          <div class="grid grid-cols-12 items-end gap-3">
            {{-- Categoría --}}
            <div class="col-span-12 md:col-span-4">
              <label class="mb-1 block text-xs text-slate-600">Categoría</label>
              <select class="js-category w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 outline-none focus:ring-2 focus:ring-indigo-500">
                <option value="">— Todas —</option>
                @foreach(($categories ?? \App\Models\Category::orderBy('name')->get()) as $cat)
                  <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                @endforeach
              </select>
            </div>

            {{-- Producto --}}
            <div class="col-span-12 md:col-span-6">
              <label class="mb-1 block text-xs text-slate-600">Producto</label>
              <select class="js-product w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 outline-none focus:ring-2 focus:ring-indigo-500">
                <option value="">— Selecciona —</option>
                @foreach(($products ?? \App\Models\Product::query()
                  ->leftJoin('categories as c','c.id','=','products.category_id')
                  ->orderBy('c.name')->orderBy('products.name')
                  ->select('products.*')->get()) as $prod)
                  <option data-category="{{ $prod->category_id }}" value="{{ $prod->id }}">
                    {{ $prod->name }} @if($prod->sku) ({{ $prod->sku }}) @endif
                  </option>
                @endforeach
              </select>
            </div>

            {{-- Cantidad total --}}
            <div class="col-span-8 md:col-span-1">
              <label class="mb-1 block text-xs text-slate-600">Cantidad</label>
              <input type="number" min="0" value="0"
                     class="js-total w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 outline-none focus:ring-2 focus:ring-indigo-500">
            </div>

            {{-- Quitar --}}
            <div class="col-span-4 md:col-span-1">
              <button type="button"
                      class="js-remove w-full rounded-xl border border-slate-200 px-3 py-2 text-sm text-slate-700 hover:bg-slate-50">
                Quitar
              </button>
            </div>
          </div>

          {{-- Desglose por atributos (se llena dinámicamente) --}}
          <div class="js-attrs-container mt-3 hidden"></div>

          {{-- Hidden para submit --}}
          <input type="hidden" name="rows[IDX][product_id]" class="js-in-product">
          <input type="hidden" name="rows[IDX][qty]"        class="js-in-qty js-in-total">
          <input type="hidden" name="rows[IDX][breakdown_multi]"      class="js-in-multi">
        </div>
      </template>

      {{-- Catálogo de productos para JS (id, name, sku, category_id) --}}
      <script type="application/json" id="all-products-json">
        @php
          $list = ($products ?? \App\Models\Product::query()
            ->leftJoin('categories as c','c.id','=','products.category_id')
            ->orderBy('c.name')->orderBy('products.name')
            ->select('products.*')->get())
            ->map(fn($p)=>['id'=>$p->id,'name'=>$p->name,'sku'=>$p->sku,'category_id'=>$p->category_id])->values();
        @endphp
        {!! $list->toJson(JSON_UNESCAPED_UNICODE) !!}
      </script>
    </form>

    {{-- Script principal (SIN Tom Select) --}}
    <script>
    (function () {
      // ========= Helpers =========
      function productLabel(p) {
        return p && p.sku ? `${p.name} (${p.sku})` : (p ? p.name : '');
      }
      function parseAllProducts() {
        const el = document.getElementById('all-products-json');
        try { return JSON.parse(el?.textContent || '[]'); } catch { return []; }
      }
      const ALL_PRODUCTS = parseAllProducts();

      // Orden de categorías según el template (para ordenar productos por cat-name y luego por producto)
      const CATEGORY_ORDER = (() => {
        const tpl = document.getElementById('row-template');
        const catSel = tpl?.content?.querySelector?.('.js-category');
        const map = {};
        if (catSel) {
          Array.from(catSel.options).forEach((opt, idx) => {
            if (opt.value) map[opt.value] = idx;
          });
        }
        return map;
      })();

      // Reconstruir select de productos (filtro/orden) SIN Tom Select
      function rebuildProductOptions(wrap){
        // toma categoría de la fila
        const catSel  = wrap.querySelector('.js-category');
        const prodSel = wrap.querySelector('.js-product');
        if (!prodSel) return;

        const catId = catSel && catSel.value ? parseInt(catSel.value, 10) : null;
        const prev  = prodSel.value;
        const MAXI  = Number.MAX_SAFE_INTEGER;

        const items = ALL_PRODUCTS
          .filter(p => !catId || p.category_id == catId)
          .map(p => ({
            value: String(p.id),
            text:  productLabel(p),
            cOrd:  (CATEGORY_ORDER[String(p.category_id)] ?? MAXI)
          }))
          .sort((a, b) => (a.cOrd - b.cOrd) || a.text.localeCompare(b.text));

        // Construir <option>
        prodSel.innerHTML = '';
        const ph = document.createElement('option');
        ph.value = ''; ph.textContent = '— Selecciona —';
        prodSel.appendChild(ph);

        items.forEach(it => {
          const opt = document.createElement('option');
          opt.value = it.value;
          opt.textContent = it.text;
          prodSel.appendChild(opt);
        });

        // Mantener selección si válida; si no, limpiar y disparar change
        if (prev && items.some(it => it.value === prev)) {
          prodSel.value = prev;
          prodSel.dispatchEvent(new Event('change', { bubbles: true }));
        } else {
          if (prodSel.value !== '') {
            prodSel.value = '';
            prodSel.dispatchEvent(new Event('change', { bubbles: true }));
          }
        }
      }

      // Construye bloques de desglose multi-atributo
      function buildMultiAttrs(wrap, attrs) {
        const cont = wrap.querySelector('.js-attrs-container');
        cont.innerHTML = '';
        if (!attrs || !attrs.length) {
          cont.classList.add('hidden');
          return;
        }
        cont.classList.remove('hidden');

        attrs.forEach(attr => {
          const block = document.createElement('div');
          block.className = 'mb-3';
          block.setAttribute('data-attrslug', attr.slug);

          const head = document.createElement('div');
          head.className = 'mb-2 text-sm font-medium';
          head.textContent = `Desglose por ${attr.name}`;
          block.appendChild(head);

          const grid = document.createElement('div');
          grid.className = 'grid grid-cols-2 gap-2 md:grid-cols-4';

          (attr.values || []).forEach(v => {
            const box = document.createElement('div');
            box.className = 'flex items-center gap-2';
            box.innerHTML = `
              <label class="w-28 text-sm">${(v.name || v.slug)}</label>
              <input type="number" min="0" value="0"
                     class="js-multi-qty w-24 rounded-lg border-0 px-2 py-1 ring-1 ring-slate-200 outline-none focus:ring-2 focus:ring-indigo-500"
                     data-attr="${attr.slug}" data-value="${v.slug}">
            `;
            grid.appendChild(box);
          });

          block.appendChild(grid);
          cont.appendChild(block);
        });
      }

      // Sincroniza hidden
      function syncHidden(wrap) {
        if (!wrap) return;
        const prod = wrap.querySelector('.js-product');
        const qty  = wrap.querySelector('.js-total');

        const inProd  = wrap.querySelector('.js-in-product');
        const inQty   = wrap.querySelector('.js-in-qty');
        const inTotal = wrap.querySelector('.js-in-total');

        if (inProd)  inProd.value  = prod ? (prod.value || '') : '';
        if (inQty)   inQty.value   = qty  ? (qty.value || '0') : '0';
        if (inTotal) inTotal.value = qty  ? (qty.value || '0') : '0';

        const groups = wrap.querySelectorAll('.js-multi-qty');
        const inMulti = wrap.querySelector('.js-in-multi');

        if (!groups.length) {
          if (inMulti) inMulti.value = '';
          return;
        }

        const out = {};
        groups.forEach(inp => {
          const a = inp.getAttribute('data-attr');
          const v = inp.getAttribute('data-value');
          const n = parseInt(inp.value || '0', 10);
          if (!a || !v) return;
          if (!out[a]) out[a] = {};
          out[a][v] = isNaN(n) ? 0 : n;
        });

        if (inMulti) {
          const payload = { attrs: Object.keys(out).map(aslug => ({ slug: aslug, values: out[aslug] })) };
          inMulti.value = JSON.stringify(payload);
        }
      }

      const rows    = document.getElementById('rows');
      const tplRow  = document.getElementById('row-template')?.content;
      const addRowBtn = document.getElementById('addRow');
      const addRowBtn2 = document.getElementById('addRow2');

      // Enlaza eventos por fila
      function attachRowEvents(wrap) {
        if (!wrap) return;

        const prod = wrap.querySelector('.js-product');
        const cat  = wrap.querySelector('.js-category');
        const attrsBox = wrap.querySelector('.js-attrs-container');

        let lastAttrsReqId = 0;

        // Quitar fila
        wrap.querySelector('.js-remove')?.addEventListener('click', () => wrap.remove());

        // Cambios en cantidad
        wrap.querySelector('.js-total')?.addEventListener('input', () => syncHidden(wrap));

        // Categoría → repoblar
        const onCategoryChange = () => {
          const prev = prod?.value || '';
          rebuildProductOptions(wrap);
          if (prod && prod.value !== prev) {
            prod.dispatchEvent(new Event('change', { bubbles: true }));
          }
          syncHidden(wrap);
        };
        if (cat) {
          cat.addEventListener('change', onCategoryChange);
          rebuildProductOptions(wrap);
        } else {
          rebuildProductOptions(wrap);
        }

        // Producto → traer atributos
        const onProductChange = async (e) => {
          const pid = e.target.value;
          if (attrsBox) { attrsBox.innerHTML = ''; attrsBox.classList.add('hidden'); }
          const inMulti = wrap.querySelector('.js-in-multi');
          if (inMulti) inMulti.value = '';

          if (!pid) { syncHidden(wrap); return; }

          const reqId = ++lastAttrsReqId;
          prod?.setAttribute('disabled', 'disabled');

          try {
            const url = `${window.location.origin}/zapatera/admin/inventory/attrs/${pid}`;
            const res = await fetch(url, { headers: { 'Accept': 'application/json' } });
            if (!res.ok) throw new Error(`HTTP ${res.status}`);
            const data = await res.json();
            if (reqId !== lastAttrsReqId) return;

            const attrs = Array.isArray(data?.attributes) ? data.attributes : [];
            if (attrs.length) {
              buildMultiAttrs(wrap, attrs);
              attrsBox?.classList.remove('hidden');
            } else {
              attrsBox?.classList.add('hidden');
            }
          } catch (err) {
            console.error('attrs fetch error:', err);
            attrsBox?.classList.add('hidden');
          } finally {
            prod?.removeAttribute('disabled');
            syncHidden(wrap);
          }
        };
        if (prod) {
          prod.addEventListener('change', onProductChange);
        }

        // Cambios dentro del desglose
        wrap.addEventListener('input', (ev) => {
          if (ev.target?.classList?.contains('js-multi-qty')) {
            syncHidden(wrap);
          }
        });

        syncHidden(wrap);
      }

      let idx = 0;
      function addRow() {
        if (!tplRow || !rows) return;
        const node = document.importNode(tplRow, true);
        const wrap = node.querySelector('.row-item');

        // Renombrar inputs con índice
        wrap.querySelectorAll('input[name]').forEach(n => n.name = n.name.replace('IDX', idx));
        idx++;

        rows.appendChild(node);
        const inserted = rows.lastElementChild;

        attachRowEvents(inserted);
        rebuildProductOptions(inserted);
        syncHidden(inserted);
      }

      addRowBtn?.addEventListener('click', addRow);
      addRowBtn2?.addEventListener('click', addRow);
      addRow(); // fila inicial

      // ========= Validación antes de enviar =========
      const form = document.getElementById('batchForm');
      if (form) {
        form.addEventListener('submit', (ev) => {
          const errors = [];
          const rowsList = Array.from(rows?.querySelectorAll('.row-item') || []);

          // Fecha >= hoy
          const dateEl = document.querySelector('input[name="date"]');
          if (dateEl && dateEl.value) {
            const todayStr = new Date().toISOString().slice(0,10);
            if (dateEl.value < todayStr) errors.push('La fecha no puede ser menor al día actual.');
          } else {
            errors.push('Debes seleccionar una fecha.');
          }

          // Debe haber al menos un producto seleccionado
          const productsSelected = rowsList
            .map(wrap => (wrap.querySelector('.js-product')?.value || '').trim())
            .filter(v => v !== '');
          if (productsSelected.length === 0) {
            errors.push('Debes añadir al menos un producto al movimiento.');
          }

          // Por fila: sumas por atributo == total
          rowsList.forEach((wrap, i) => {
            const prodVal = (wrap.querySelector('.js-product')?.value || '').trim();
            if (!prodVal) return;

            const total  = parseInt(wrap.querySelector('.js-total')?.value || '0', 10);
            const inputs = wrap.querySelectorAll('.js-multi-qty');
            if (!inputs.length) return;

            const sums = {};
            inputs.forEach(inp => {
              const a = inp.getAttribute('data-attr') || '';
              const v = parseInt(inp.value || '0', 10);
              if (!sums[a]) sums[a] = 0;
              if (!isNaN(v)) sums[a] += v;
            });

            Object.entries(sums).forEach(([attrSlug, sum]) => {
              if (sum !== total) {
                errors.push(`Fila ${i + 1}: el desglose del atributo "${attrSlug}" suma ${sum} y debe ser exactamente ${total}.`);
              }
            });
          });

          if (errors.length) {
            ev.preventDefault();

            // Banner de errores con botón cerrar
            let banner = document.getElementById('client-errors');
            if (!banner) {
              banner = document.createElement('div');
              banner.id = 'client-errors';
              banner.className = 'mb-3 rounded-xl border border-rose-200 bg-rose-50 p-3 text-sm text-rose-700 relative';
              form.parentNode.insertBefore(banner, form);
            }

            const closeBtn = `<button type="button" aria-label="Cerrar"
              style="position:absolute;top:6px;right:8px;padding:4px 8px;border:0;background:transparent;font-weight:bold;cursor:pointer;">×</button>`;
            banner.innerHTML = `${closeBtn}<ul class="ml-5 list-disc">${errors.map(e => `<li>${e}</li>`).join('')}</ul>`;

            const btn = banner.querySelector('button'); if (btn) btn.onclick = () => banner.remove();
            banner.scrollIntoView({ behavior: 'smooth', block: 'start' });
            return false;
          }
        });
      }

      // ===== Fecha (refuerzo min/value por si el HTML no lo trae) =====
      const dateInput = document.querySelector('input[name="date"]');
      if (dateInput) {
        const todayStr = new Date().toISOString().slice(0,10);
        if (!dateInput.min)   dateInput.min   = todayStr;
        if (!dateInput.value) dateInput.value = todayStr;
      }
    })();
    </script>
  </x-admin-layout>
