{{-- resources/views/zapatera/admin/inventory/index.blade.php --}}
<x-admin-layout title="Inventario — Principal">
    <x-slot:header>
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-xl font-semibold text-slate-900">Inventario</h1>
          <p class="text-sm text-slate-500">Gestiona tu inventario de productos.</p>
        </div>
        <x-user-role-badges />
      </div>
    </x-slot:header>

    @php
      // Formateador con 2 decimales y separador de miles (para vistas normales)
      $fmt = fn($n) => number_format((float)$n, 2, '.', ',');
      // Formato "crudo": sin separadores ni decimales (para totales de página)
      // Si en el futuro quieres volver a separadores/decimales, usa $fmt(...) en vez de $fmtRaw(...)
      $fmtRaw = fn($n) => (string) (int) round((float)$n);
    @endphp

    <section class="space-y-6">
      {{-- ========= FILTROS ========= --}}
      @php
        $q   = request('q','');
        $cid = request('category_id');
        $sf  = request('stock','nonzero'); // all|zero|nonzero
      @endphp

      <div class="bg-white rounded-2xl shadow-sm border border-slate-200 p-4">
        <form method="GET" class="grid grid-cols-12 gap-3 items-end">
          <div class="col-span-12 md:col-span-4">
            <label class="block text-xs text-slate-600 mb-1">Buscar</label>
            <input type="text" name="q" value="{{ $q }}"
                   class="w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 focus:ring-2 focus:ring-indigo-500 outline-none"
                   placeholder="Nombre">
          </div>

          <div class="col-span-6 md:col-span-3">
            <label class="block text-xs text-slate-600 mb-1">Categoría</label>
            <select name="category_id"
                    class="w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 focus:ring-2 focus:ring-indigo-500 outline-none">
              <option value="">Todas</option>
              @foreach(($categories ?? \App\Models\Category::orderBy('name')->get()) as $c)
                <option value="{{ $c->id }}" @selected($cid == $c->id)>{{ $c->name }}</option>
              @endforeach
            </select>
          </div>

          <div class="col-span-6 md:col-span-3">
            <label class="block text-xs text-slate-600 mb-1">Mostrar</label>
            <select name="stock"
                    class="w-full rounded-xl px-3 py-2 ring-1 ring-slate-200 focus:ring-2 focus:ring-indigo-500 outline-none">
              <option value="all"     @selected($sf==='all')>Todos</option>
              <option value="zero"    @selected($sf==='zero')>Solo inventario cero</option>
              <option value="nonzero" @selected($sf==='nonzero')>Solo con stock</option>
            </select>
          </div>

          <div class="col-span-12 md:col-span-2 flex gap-2">
            <button class="px-4 py-2 rounded-xl bg-indigo-600 hover:bg-indigo-700 text-white shadow-sm w-full md:w-auto">
              Filtrar
            </button>
            <a href="{{ url()->current() }}"
               class="px-4 py-2 rounded-xl border border-slate-200 hover:bg-slate-50 w-full md:w-auto text-center">
              Limpiar
            </a>
          </div>
        </form>
      </div>

      {{-- Barra de tasas (reutilizable) --}}
      {{--  @if(!empty($currencies))
        <x-currency.rates-bar :currencies="$currencies" />
      @endif  --}}

      {{-- Auto-carga desde BD, cacheada 5 min por defecto --}}
      {{--  <x-currency.rates-bar decimals="4" show-both variant="scroll" />  --}}
        @php
            /** @var \App\Services\CurrencyService $currSrv */
            $currSrv = app(\App\Services\CurrencyService::class);
            $currencies = $currencies ?? $currSrv->listForDisplay();
        @endphp
        {{-- Totales de inversión (página) --}}
        <x-inventory.totales-inversion
            :items="$products"
            :currencies="$currencies"
            render-type="simple"     {{-- simple | complex (default: simple) --}}
            title="Totales de inversión"
            raw="false" {{-- true: muestra sin decimales | false: muestra con 2 decimales --}}
            only-with-stock="true"
        />


      {{-- ========= LISTADO ========= --}}
      <div class="overflow-x-auto bg-white rounded-2xl shadow-sm border border-slate-200">
        <table class="w-full text-sm text-left text-slate-700">
          <thead class="bg-slate-50 text-slate-500 uppercase text-xs tracking-wider">
            <tr>
              <th class="px-4 py-3">Producto</th>
              <th class="px-4 py-3">Costo</th>
              <th class="px-4 py-3">Precio</th>
              <th class="px-4 py-3">Ganancia</th>
              <th class="px-4 py-3 text-right">Stock</th>
              <th class="px-4 py-3 text-right">Acciones</th>
            </tr>
          </thead>

          @forelse($products as $p)
            @php
              // ===== Datos monetarios unitarios por producto (del SELECT del controlador) =====
              $cost      = isset($p->cost)       ? (float)$p->cost       : null;   // products.cost
              $price     = isset($p->price)      ? (float)$p->price      : null;   // products.base_price AS price
              $costRate  = isset($p->cost_rate)  ? (float)$p->cost_rate  : 0.0;    // currencies.rate_to_primary
              $priceRate = isset($p->price_rate) ? (float)$p->price_rate : 0.0;    // currencies.rate_to_primary
              $costCode  = $p->cost_code  ?? '';
              $priceCode = $p->price_code ?? '';

              // Ganancia unitaria en ambas monedas
              $gainInCost = $gainInPrice = null;
              if ($cost !== null && $price !== null && $costRate>0 && $priceRate>0) {
                $priceInCost = $price * ($priceRate / $costRate);
                $costInPrice = $cost  * ($costRate  / $priceRate);
                $gainInCost  = $priceInCost - $cost;          // en moneda de COSTO
                $gainInPrice = $price - $costInPrice;         // en moneda de PRECIO
              }

              // ====== Stock neto (del SELECT del controlador si viene; si no, calculado abajo) ======
              $stockReal = (int) ($p->stock_qty ?? 0);

              // ====== Desglose por atributos (sin relaciones) ======
              $aggFlat   = []; // 'attr: val' => qty neta

              // Detectar tabla/columna de movimientos
              $movementTable = Schema::hasTable('inventory_movements')
                  ? 'inventory_movements'
                  : (Schema::hasTable('stock_movements') ? 'stock_movements' : null);

              $productColumn = null;
              if ($movementTable) {
                foreach (['product_id','products_id','productId','productID','item_id'] as $col) {
                  if (Schema::hasColumn($movementTable, $col)) { $productColumn = $col; break; }
                }
              }

              // Cargar líneas de movimientos SOLO de este producto para armar el desglose
              if ($movementTable && $productColumn) {
                $pid  = $p->product_id ?? $p->id ?? null;
                if ($pid) {
                  $rows = DB::table("$movementTable as m")
                    ->select('m.qty','m.type','m.attribute_values')
                    ->where("m.$productColumn", '=', $pid)
                    ->get();

                  foreach ($rows as $m) {
                    $sign = in_array($m->type, ['out','salida'], true) ? -1 : 1;
                    $q    = $sign * (int)($m->qty ?? 0);

                    $vals = is_string($m->attribute_values)
                              ? json_decode($m->attribute_values, true)
                              : (array)$m->attribute_values;

                    if (is_array($vals)) {
                      foreach ($vals as $a => $v) {
                        if ($v === '' || $v === null) continue;
                        $label = trim($a).': '.trim((string)$v);
                        $aggFlat[$label] = ($aggFlat[$label] ?? 0) + $q;
                      }
                    }
                  }
                }
              }

              // Agrupar: attr => [value => qty] (ocultando ceros)
              $groups = [];
              foreach ($aggFlat as $label => $qty) {
                [$a,$v] = array_map('trim', explode(':', $label, 2) + ['', '']);
                if ($a === '' || $qty == 0) continue;
                $groups[$a] = $groups[$a] ?? [];
                $groups[$a][$v] = ($groups[$a][$v] ?? 0) + (int)$qty;
              }
              ksort($groups, SORT_NATURAL|SORT_FLAG_CASE);
              foreach ($groups as &$vals) { ksort($vals, SORT_NATURAL|SORT_FLAG_CASE); }
              unset($vals);
            @endphp

            <tbody x-data="{ open:false }">
              {{-- Fila principal --}}
              <tr>
                <td class="px-4 py-3">
                  <div class="font-medium">{{ $p->product_name ?? $p->name ?? '—' }}</div>
                  @if(!empty($p->category_name))
                    <div class="text-xs text-slate-500">{{ $p->category_name }}</div>
                  @endif
                </td>

                {{-- Costo (UNIT) --}}
                <td class="px-4 py-3">
                  <div class="font-medium text-slate-800">
                    @if($cost !== null)
                      {{ $fmt($cost) }}
                      @if($costCode !== '')
                        <small class="ml-1 px-1.5 py-0.5 rounded-md text-[10px] font-semibold border
                          {{ strtoupper($costCode)==='USD'
                            ? 'bg-emerald-50 text-emerald-700 border-emerald-200'
                            : 'bg-sky-50 text-sky-700 border-sky-200' }}">
                          {{ $costCode }}
                        </small>
                      @endif
                    @else — @endif
                  </div>
                </td>

                {{-- Precio (UNIT) --}}
                <td class="px-4 py-3">
                  <div class="font-medium text-slate-800">
                    @if($price !== null)
                      {{ $fmt($price) }}
                      @if($priceCode !== '')
                        <small class="ml-1 px-1.5 py-0.5 rounded-md text-[10px] font-semibold border
                          {{ strtoupper($priceCode)==='USD'
                            ? 'bg-emerald-50 text-emerald-700 border-emerald-200'
                            : 'bg-sky-50 text-sky-700 border-sky-200' }}">
                          {{ $priceCode }}
                        </small>
                      @endif
                    @else — @endif
                  </div>
                </td>

                {{-- Ganancia (UNIT, 2 líneas, separadas) --}}
                <td class="px-4 py-3">
                    <div class="font-medium text-slate-800">
                    <div class="space-y-1.5 leading-tight">
                        @if($gainInCost !== null)
                        <div class="flex items-center gap-2">
                            <span>{{ $fmt($gainInCost) }}</span>
                            @if($costCode !== '')
                            <small class="px-1.5 py-0.5 rounded-md text-[10px] font-semibold border
                                {{ strtoupper($costCode)==='USD'
                                    ? 'bg-emerald-50 text-emerald-700 border-emerald-200'
                                    : 'bg-sky-50 text-sky-700 border-sky-200' }}">
                                {{ $costCode }}
                            </small>
                            @endif
                        </div>
                        @else
                        <div class="text-slate-400">—</div>
                        @endif

                        @if($gainInCost !== null && $gainInPrice !== null)
                        <div class="h-px bg-slate-100"></div>
                        @endif

                        @if($gainInPrice !== null)
                        <div class="flex items-center gap-2">
                            <span>{{ $fmt($gainInPrice) }}</span>
                            @if($priceCode !== '')
                            <small class="px-1.5 py-0.5 rounded-md text-[10px] font-semibold border
                                {{ strtoupper($priceCode)==='USD'
                                    ? 'bg-emerald-50 text-emerald-700 border-emerald-200'
                                    : 'bg-sky-50 text-sky-700 border-sky-200' }}">
                                {{ $priceCode }}
                            </small>
                            @endif
                        </div>
                        @else
                        <div class="text-slate-400">—</div>
                        @endif
                    </div>
                    </div>
                </td>


                {{-- Stock --}}
                <td class="px-4 py-3 text-right font-semibold tabular-nums">
                  <span class="inline-flex items-center rounded-md bg-slate-50 px-2 py-0.5 ring-1 ring-inset ring-slate-200">
                    {{ $stockReal }}
                  </span>
                </td>

                {{-- Acciones --}}
                <td class="px-4 py-3 text-right space-x-2">
                  <button type="button"
                          class="inline-flex items-center gap-1 px-3 py-1.5 border rounded-xl text-xs font-medium
                                 border-sky-200 text-sky-700 bg-sky-50 hover:bg-sky-100"
                          @click="open = !open">
                    <svg x-show="!open" xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7"/>
                    </svg>
                    <svg x-show="open" xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                    Desglose
                  </button>

                  <a href="{{ route('zapatera.admin.inventory.history.product', $p->product_id ?? $p->id) }}"
                     class="inline-flex items-center px-3 py-1.5 border border-slate-200 hover:bg-slate-50 rounded-xl text-xs font-medium">
                    Historial
                  </a>
                </td>
              </tr>

              {{-- Desglose por atributos --}}
              <tr>
                <td colspan="6" class="px-0">
                  <div x-show="open" x-cloak>
                    <div class="border-t border-slate-100 pt-3 pb-4">
                      <div class="px-4">
                        <div class="mb-3 inline-flex items-center gap-2 rounded-full bg-slate-50 px-3 py-1 text-[11px] font-semibold uppercase tracking-wide text-slate-600 ring-1 ring-inset ring-slate-200">
                          <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M3 5.25A2.25 2.25 0 0 1 5.25 3H9A2.25 2.25 0 0 1 11.25 5.25V9A2.25 2.25 0 0 1 9 11.25H5.25A2.25 2.25 0 0 1 3 9V5.25Z"/>
                            <path d="M12.75 5.25A2.25 2.25 0 0 1 15 3h3.75A2.25 2.25 0 0 1 21 5.25V9A2.25 2.25 0 0 1 18.75 11.25H15A2.25 2.25 0 0 1 12.75 9V5.25Z"/>
                            <path d="M3 14.25A2.25 2.25 0 0 1 5.25 12H9A2.25 2.25 0 0 1 11.25 14.25V18A2.25 2.25 0 0 1 9 20.25H5.25A2.25 2.25 0 0 1 3 18v-3.75Z"/>
                            <path d="M12.75 14.25A2.25 2.25 0 0 1 15 12h3.75A2.25 2.25 0 0 1 21 14.25V18A2.25 2.25 0 0 1 18.75 20.25H15A2.25 2.25 0 0 1 12.75 18v-3.75Z"/>
                          </svg>
                          Atributos
                        </div>

                        @if(empty($groups))
                          <div class="text-sm text-slate-500 italic">Sin desglose de atributos</div>
                        @else
                          <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                            @foreach($groups as $attr => $vals)
                              <div class="rounded-2xl border border-slate-200 bg-white shadow-sm">
                                <div class="px-3 py-2 text-xs font-semibold text-slate-700 bg-slate-50/80 border-b border-slate-100 rounded-t-2xl">
                                  {{ ucfirst($attr) }}
                                </div>
                                <ul class="divide-y divide-slate-100">
                                  @foreach($vals as $val => $qty)
                                    @continue($qty == 0)
                                    <li class="flex items-center justify-between px-3 py-2">
                                      <span class="text-sm text-slate-700 truncate">{{ $val !== '' ? $val : '—' }}</span>
                                      <span class="text-xs font-semibold tabular-nums rounded-md bg-emerald-50 text-emerald-700 px-2 py-0.5 ring-1 ring-inset ring-emerald-200">
                                        {{ (int)$qty }}
                                      </span>
                                    </li>
                                  @endforeach
                                </ul>
                              </div>
                            @endforeach
                          </div>
                        @endif
                      </div>

                      <div class="mt-5 mx-4">
                        <div class="h-px w-full bg-gradient-to-r from-transparent via-slate-200 to-transparent"></div>
                      </div>
                    </div>
                  </div>
                </td>
              </tr>
            </tbody>
          @empty
            <tbody>
              <tr>
                <td colspan="6" class="px-4 py-6 text-center text-slate-500 italic">
                  Sin resultados
                </td>
              </tr>
            </tbody>
          @endforelse
        </table>
      </div>

      <div class="mt-6">{{ $products->links() }}</div>
    </section>
  </x-admin-layout>
