{{-- resources/views/zapatera/admin/inventory/history.blade.php --}}
<x-admin-layout title="Inventario — Historial">
    <x-slot:header>
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-xl font-semibold text-slate-900">Inventario — Historial</h1>
          <p class="text-sm text-slate-500">Consulta el historial de tus movimientos.</p>
        </div>
        <div class="flex items-center gap-2">
          <a href="{{ route('zapatera.admin.inventory.index') }}"
             class="inline-flex items-center px-3 py-2 rounded-xl border border-slate-200 hover:bg-slate-50">
            ← Regresar
          </a>
          <x-user-role-badges />
        </div>
      </div>
    </x-slot:header>

    <section class="space-y-6">
      @if(session('status'))
        <div class="p-3 rounded-xl bg-emerald-50 text-emerald-700 text-sm border border-emerald-200">
          {{ session('status') }}
        </div>
      @endif

      {{-- ====== FILTROS (colapsable) ====== --}}
      <form method="GET" action="{{ route('zapatera.admin.inventory.history') }}"
            x-data="filtersUI({
              allProducts: @js($products ?? []),
              preCategory: '{{ request('category_id') }}',
              preProduct:  '{{ request('product_id') }}',
              isOpen: {{ request()->hasAny(['from','to','category_id','product_id','type']) ? 'true' : 'true' }}
            })"
            class="bg-white rounded-2xl border border-slate-200">

        <div class="flex items-center justify-between px-4 py-3 border-b border-slate-100">
          <div class="text-sm font-medium text-slate-700">Filtros</div>
          <button type="button" @click="open = !open"
                  :class="open
                    ? 'inline-flex items-center gap-1 rounded-lg border px-3 py-1.5 text-xs bg-violet-50 border-violet-200 text-violet-700 hover:bg-violet-100 appearance-none'
                    : 'inline-flex items-center gap-1 rounded-lg border px-3 py-1.5 text-xs bg-sky-50 border-sky-200 text-sky-700 hover:bg-sky-100 appearance-none'">
            <svg x-show="open" x-cloak xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
            </svg>
            <svg x-show="!open" x-cloak xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7"/>
            </svg>
            <span x-text="open ? 'Ocultar' : 'Mostrar'"></span>
          </button>
        </div>

        <div class="p-4 space-y-4" x-show="open" x-cloak>
          {{-- Fila 1 --}}
          <div class="grid grid-cols-1 md:grid-cols-12 gap-3 items-end">
            <div class="md:col-span-2">
              <label class="block text-xs font-medium text-slate-500 mb-1">Tipo</label>
              <select name="type" class="w-36 md:w-full rounded-lg border-slate-300">
                <option value="">Todos</option>
                <option value="in"  @selected(request('type')==='in')>Entrada</option>
                <option value="out" @selected(request('type')==='out')>Salida</option>
              </select>
            </div>
            <div class="md:col-span-5">
              <label class="block text-xs font-medium text-slate-500 mb-1">Desde</label>
              <input type="date" name="from" value="{{ request('from') }}" class="w-full rounded-lg border-slate-300">
            </div>
            <div class="md:col-span-5">
              <label class="block text-xs font-medium text-slate-500 mb-1">Hasta</label>
              <input type="date" name="to" value="{{ request('to') }}" class="w-full rounded-lg border-slate-300">
            </div>
          </div>

          {{-- Fila 2 --}}
          <div class="grid grid-cols-1 md:grid-cols-12 gap-3">
            <div class="md:col-span-5">
              <label class="block text-xs font-medium text-slate-500 mb-1">Categoría</label>
              <select name="category_id" x-model="categoryId" @change="onCategoryChange" class="w-full rounded-lg border-slate-300">
                <option value="">Todas</option>
                @foreach(($categories ?? []) as $c)
                  <option value="{{ $c->id }}" @selected(request('category_id')==$c->id)>{{ $c->name }}</option>
                @endforeach
              </select>
            </div>
            <div class="md:col-span-7">
              <label class="block text-xs font-medium text-slate-500 mb-1">Producto</label>
              <select name="product_id" x-model="productId" class="w-full rounded-lg border-slate-300">
                <option value="">Todos</option>
                <template x-for="p in filteredProducts" :key="p.id">
                  <option :value="p.id" x-text="p.name" :selected="String(p.id)===String(productId)"></option>
                </template>
              </select>
            </div>
          </div>

          {{-- Fila 3 --}}
          <div class="flex items-center justify-center gap-3 pt-1">
            <button type="submit"
                    class="inline-flex items-center gap-2 px-5 py-2 rounded-full font-semibold
                           text-white bg-indigo-600 border border-indigo-600 shadow-sm
                           hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500/50">
              Filtrar
            </button>
            <a href="{{ route('zapatera.admin.inventory.history') }}"
               class="inline-flex items-center gap-2 px-5 py-2 rounded-full font-semibold
                      text-indigo-700 bg-indigo-50 border border-indigo-200
                      hover:bg-indigo-100 focus:outline-none focus:ring-2 focus:ring-indigo-400/30">
              Limpiar
            </a>
          </div>
        </div>

        <script>
          function filtersUI({allProducts, preCategory, preProduct, isOpen}) {
            return {
              open: isOpen,
              allProducts,
              categoryId: preCategory || '',
              productId: preProduct || '',
              get filteredProducts() {
                if (!this.categoryId) return this.allProducts;
                return this.allProducts.filter(p => String(p.category_id) === String(this.categoryId));
              },
              onCategoryChange() {
                if (this.productId) {
                  const ok = this.filteredProducts.some(p => String(p.id)===String(this.productId));
                  if (!ok) this.productId = '';
                }
              }
            }
          }

          // Lote: estado global
          function batchState2(el){
            const batchId = Number(el.dataset.batchId);
            const total   = Number(el.dataset.total);
            return {
              batchId, productsTotal: total,
              openAll:false,
              openKeys:new Set(),
              toggleAll(){
                const next = !this.openAll;
                window.dispatchEvent(new CustomEvent('toggle-all-breakdowns', { detail:{ batchId, open: next } }));
                this.openAll = next;
                if(!next) this.openKeys.clear();
              },
              init(){
                window.addEventListener('product-breakdown-state', (e)=>{
                  const d = e.detail || {};
                  if(d.batchId !== batchId) return;
                  if(d.open) this.openKeys.add(String(d.key)); else this.openKeys.delete(String(d.key));
                  this.openAll = (this.openKeys.size === this.productsTotal);
                });
              }
            }
          }
          // Producto: estado individual
          function productItem2(el){
            const batchId = Number(el.dataset.batchId);
            const key     = String(el.dataset.key);
            return {
              open:false,
              report(){ window.dispatchEvent(new CustomEvent('product-breakdown-state',{ detail:{ batchId, key, open:this.open } })); },
              init(){
                this.report();
                const h = (e)=>{ if(e.detail?.batchId === batchId){ this.open = e.detail.open; this.report(); } };
                window.addEventListener('toggle-all-breakdowns', h);
              }
            }
          }
        </script>
      </form>

      <x-currency.rates-bar decimals="4" show-both variant="scroll" />

      @php
        // Tamaño de texto para el código de moneda
        $curSmall = 'text-[10px] uppercase font-semibold tracking-wide';

        // Color por código de moneda
        $curClass = function($code) {
            $c = strtoupper(trim((string)$code));
            return match ($c) {
            'USD' => 'text-emerald-600',
            'CUP' => 'text-sky-600',
            default => 'text-slate-500',
            };
        };
      @endphp
      {{-- =================== VISTA AGRUPADA POR LOTES =================== --}}
      @if(isset($batches) && $batches)
        @foreach($batches as $b)
          @php
            $tipo  = $b->type ?? 'in';
            $isIn  = in_array($tipo, ['in','entrada'], true);
            $badge = $isIn ? 'bg-emerald-50 text-emerald-700 border-emerald-200' : 'bg-rose-50 text-rose-700 border-rose-200';

            $rows = $lines[$b->id] ?? collect();
            $byProduct = $rows->groupBy(fn($r) => $r->product_id ?? $r->m_product_id ?? 0);
            $productsTotal = $byProduct->count();

            // === FORMATOS ===
            // Unitario (por producto): bonito, 2 decimales + miles
            //$fmtPretty = fn($n) => number_format((float)$n, 2, '.', ',');
            // TOTAL por lote: crudo (sin miles ni decimales) — si se quiere volver al bonito, usar $fmtPretty
            $fmtRaw    = fn($n) => $n === null ? '—' : (string) (int) round((float)$n);
          @endphp

          <div x-data="batchState2($el)" data-batch-id="{{ $b->id }}" data-total="{{ $productsTotal }}"
               class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">

            {{-- Barra superior del lote --}}
            <div class="flex items-center justify-between px-4 py-3 border-b border-slate-100">
              <div class="space-y-1">
                <div class="flex items-center gap-3">
                  <span class="px-2 py-0.5 text-xs rounded-full border {{ $badge }}">{{ $isIn ? 'Entrada' : 'Salida' }}</span>
                  <span class="text-sm text-slate-500">Lote #{{ $b->id }} • {{ \Illuminate\Support\Carbon::parse($b->created_at)->format('Y-m-d H:i') }}</span>
                </div>
                @if(!empty($b->note))
                  <div class="text-sm text-slate-600">Nota: {{ $b->note }}</div>
                @endif
              </div>
              <div class="flex items-center gap-2">
                <button type="button" @click.stop="toggleAll()"
                        :class="openAll
                          ? 'inline-flex items-center gap-1 rounded-lg border px-3 py-1.5 text-xs bg-violet-50 border-violet-200 text-violet-700 hover:bg-violet-100 appearance-none'
                          : 'inline-flex items-center gap-1 rounded-lg border px-3 py-1.5 text-xs bg-sky-50 border-sky-200 text-sky-700 hover:bg-sky-100 appearance-none'">
                  <svg x-show="openAll" x-cloak xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                  </svg>
                  <svg x-show="!openAll" x-cloak xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7"/>
                  </svg>
                  <span>Desgloses</span>
                </button>

                <form action="{{ route('zapatera.admin.inventory.stock_move_baches.destroy', $b->id) }}" method="POST"
                      onsubmit="return confirm('¿Eliminar TODO el lote? Se revertirá el stock.');">
                  @csrf @method('DELETE')
                  <button type="submit"
                          class="inline-flex items-center gap-1 rounded-lg border border-rose-200 bg-white px-3 py-1.5 text-xs text-rose-700 hover:bg-rose-50 appearance-none">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                      <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 100 2h.293l.853 10.24A2 2 0 007.139 18h5.722a2 2 0 001.993-1.76L15.707 6H16a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0010 2H9zM8 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm4 0a1 1 0 10-2 0v6a1 1 0 102 0V8z" clip-rule="evenodd"/>
                    </svg>
                    <span>Eliminar</span>
                  </button>
                </form>
              </div>
            </div>

            {{-- Variables de sumatoria por lote --}}
            @php
              // NOTA: Idealmente el controlador debería pasar $primaryCode y $usdRate explícitos.
              $primaryCode = null; $usdRate = null;

              $sumCostPrimary = 0.0; $sumPricePrimary = 0.0; $sumGainPrimary = 0.0;
              $sumCostUSD = 0.0;     $sumPriceUSD = 0.0;     $sumGainUSD = 0.0;
            @endphp

            {{-- Productos del lote --}}
            <div class="divide-y divide-slate-100">
              @forelse($byProduct as $pid => $items)
                @php
                  $first = $items->first();

                  // Detectar códigos/rates
                  if (!$primaryCode) {
                    if (!empty($first->cost_rate)  && (float)$first->cost_rate === 1.0 && !empty($first->cost_code))  $primaryCode = $first->cost_code;
                    if (!empty($first->price_rate) && (float)$first->price_rate=== 1.0 && !empty($first->price_code)) $primaryCode = $first->price_code;
                  }
                  if (!$usdRate) {
                    if (!empty($first->cost_code)  && strtoupper($first->cost_code)==='USD'  && !empty($first->cost_rate))  $usdRate = (float)$first->cost_rate;
                    if (!empty($first->price_code) && strtoupper($first->price_code)==='USD' && !empty($first->price_rate)) $usdRate = (float)$first->price_rate;
                  }

                  $totalQty = 0; $agg = [];
                  foreach ($items as $m) {
                    $q = (int)($m->qty ?? 0); $totalQty += $q;
                    $vals = is_string($m->attribute_values) ? json_decode($m->attribute_values, true) : (array)$m->attribute_values;
                    if (is_array($vals)) foreach ($vals as $a => $v) {
                      if ($v === '' || $v === null) continue;
                      $label = $a . ': ' . $v;
                      $agg[$label] = ($agg[$label] ?? 0) + $q;
                    }
                  }
                  ksort($agg, SORT_NATURAL|SORT_FLAG_CASE);

                  // Monetario unitario
                  $cost      = isset($first->cost)  ? (float)$first->cost  : null;
                  $price     = isset($first->price) ? (float)$first->price : null;
                  $costRate  = isset($first->cost_rate)  ? (float)$first->cost_rate  : 0.0;    // rate_to_primary
                  $priceRate = isset($first->price_rate) ? (float)$first->price_rate : 0.0;    // rate_to_primary
                  $costCode  = $first->cost_code  ?? null;
                  $priceCode = $first->price_code ?? null;

                  // Ganancia UNIT (dos monedas)
                  $gainInCost = $gainInPrice = null;
                  if ($cost !== null && $price !== null && $costRate>0 && $priceRate>0) {
                    $priceInCost = $price * ($priceRate / $costRate);
                    $costInPrice = $cost  * ($costRate  / $priceRate);
                    $gainInCost  = $priceInCost - $cost;
                    $gainInPrice = $price - $costInPrice;
                  }

                  // Sumatorias extendidas (a primaria y USD)
                  $extCostPrimary  = ($cost !== null  && $costRate  > 0) ? ($cost  * $costRate  * $totalQty) : 0.0;
                  $extPricePrimary = ($price !== null && $priceRate > 0) ? ($price * $priceRate * $totalQty) : 0.0;
                  $extGainPrimary  = $extPricePrimary - $extCostPrimary;

                  $sumCostPrimary  += $extCostPrimary;
                  $sumPricePrimary += $extPricePrimary;
                  $sumGainPrimary  += $extGainPrimary;

                  if (!empty($usdRate) && $usdRate > 0) {
                    $sumCostUSD  += $extCostPrimary  / $usdRate;
                    $sumPriceUSD += $extPricePrimary / $usdRate;
                    $sumGainUSD  += $extGainPrimary  / $usdRate;
                  }
                @endphp

                <div x-data="productItem2($el)" data-batch-id="{{ $b->id }}" data-key="{{ $pid }}">
                  {{-- Cabecera producto --}}
                  <div class="px-4 py-3 bg-slate-50">
                    <div class="grid grid-cols-12 gap-4 items-start">
                      <div class="col-span-12 md:col-span-4 min-w-0">
                        <div class="text-[11px] uppercase text-slate-500">Producto</div>
                        <div class="font-medium text-slate-800 truncate" title="{{ $first->product_name ?? '' }}">
                          {{ $first->product_name ?? '—' }}
                        </div>
                      </div>

                      <div class="col-span-6 md:col-span-2">
                        <div class="text-[11px] uppercase text-slate-500">Costo</div>
                        <div class="font-medium text-slate-800">
                          @if($cost !== null)
                            {{ $fmtRaw($cost) }}
                            @if($costCode)
                                <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($costCode) }}">{{ $costCode }}</small>
                            @endif
                          @else — @endif
                        </div>
                      </div>

                      <div class="col-span-6 md:col-span-2">
                        <div class="text-[11px] uppercase text-slate-500">Precio</div>
                        <div class="font-medium text-slate-800">
                          @if($price !== null)
                            {{ $fmtRaw($price) }}
                            @if($priceCode)
                                <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($priceCode) }}">{{ $priceCode }}</small>
                            @endif
                          @else — @endif
                        </div>
                      </div>

                      <div class="col-span-12 md:col-span-2">
                        <div class="text-[11px] uppercase text-slate-500">Ganancia</div>
                        <div class="font-medium text-slate-800 leading-tight">
                          @if($gainInCost !== null)
                            {{ $fmtRaw($gainInCost) }}
                            @if($costCode)
                              <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($costCode) }}">{{ $costCode }}</small>
                            @endif
                            <br>
                          @else —<br> @endif

                          @if($gainInPrice !== null)
                            {{ $fmtRaw($gainInPrice) }}
                            @if($priceCode)
                              <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($priceCode) }}">{{ $priceCode }}</small>
                            @endif
                          @else — @endif
                        </div>
                      </div>

                      <div class="col-span-6 md:col-span-1">
                        <div class="text-[11px] uppercase text-slate-500">Cantidad</div>
                        <div class="font-semibold text-slate-900">{{ $totalQty }}</div>
                      </div>

                      <div class="col-span-6 md:col-span-1">
                        <div class="text-right md:text-right text-[11px] uppercase text-slate-500">Acciones</div>
                        <div class="mt-1 flex md:flex-col md:items-stretch items-center justify-end gap-2">
                          <button type="button"
                                  @click="open = !open; report()"
                                  :class="open
                                    ? 'inline-flex items-center gap-1 rounded-lg border px-3 py-1.5 text-xs bg-violet-50 border-violet-200 text-violet-700 hover:bg-violet-100 appearance-none'
                                    : 'inline-flex items-center gap-1 rounded-lg border px-3 py-1.5 text-xs bg-sky-50 border-sky-200 text-sky-700 hover:bg-sky-100 appearance-none'">
                            <svg x-show="open" x-cloak xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                            <svg x-show="!open" x-cloak xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7"/>
                            </svg>
                            <span>Desglose</span>
                          </button>

                          <form method="POST"
                                action="{{ route('zapatera.admin.inventory.all_movements.destroy', ['batch_id'=>$b->id,'producto_id'=>$pid]) }}"
                                onsubmit="return confirm('¿Eliminar TODAS las líneas de este producto en el lote? Se revertirá el stock.');"
                                class="inline-block">
                            @csrf @method('DELETE')
                            <button type="submit"
                                    class="w-full inline-flex items-center justify-center gap-1 rounded-lg border border-rose-200 bg-white px-3 py-1.5 text-xs text-rose-700 hover:bg-rose-50 appearance-none">
                              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 100 2h.293l.853 10.24A2 2 0 007.139 18h5.722a2 2 0 001.993-1.76L15.707 6H16a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0010 2H9zM8 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm4 0a1 1 0 10-2 0v6a1 1 0 102 0V8z" clip-rule="evenodd"/>
                              </svg>
                              <span>Eliminar</span>
                            </button>
                          </form>
                        </div>
                      </div>
                    </div>
                  </div>

                  {{-- Desglose atributos --}}
                  <div class="px-4 py-4" x-show="open" x-cloak>
                    @php
                      $byAttr = [];
                      foreach($agg as $label => $count){
                        [$att,$val] = array_pad(explode(':', $label, 2), 2, '');
                        $att = trim($att); $val = trim($val);
                        if($att==='') $att='—'; if($val==='') $val='—';
                        $byAttr[$att][$val] = ($byAttr[$att][$val] ?? 0) + (int)$count;
                      }
                    @endphp

                    <div class="flex items-center gap-2 mb-3">
                      <span class="inline-flex items-center gap-1 px-2 py-1 rounded-full text-[11px] font-medium bg-slate-50 border border-slate-200 text-slate-600">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7"/>
                        </svg>
                        ATRIBUTOS
                      </span>
                      <span class="text-xs text-slate-400">Total: {{ $totalQty }}</span>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3">
                      @forelse($byAttr as $attName => $values)
                        @php ksort($values, SORT_NATURAL|SORT_FLAG_CASE); @endphp
                        <div class="rounded-xl border border-slate-200 overflow-hidden bg-white">
                          <div class="px-3 py-2 text-[12px] font-medium text-slate-600 bg-slate-50">{{ $attName }}</div>
                          @foreach($values as $val => $cnt)
                            <div class="px-3 py-2 flex items-center justify-between">
                              <span class="text-slate-700">{{ $val }}</span>
                              <span class="inline-flex items-center justify-center min-w-[26px] h-6 px-2 text-[11px] font-semibold rounded-full border border-emerald-200 bg-emerald-50 text-emerald-700">{{ $cnt }}</span>
                            </div>
                          @endforeach
                        </div>
                      @empty
                        <div class="col-span-1 sm:col-span-2 lg:col-span-4">
                          <div class="px-4 py-6 text-sm text-slate-500 italic bg-slate-50 rounded-xl border border-slate-200">
                            Sin desglose de atributos
                          </div>
                        </div>
                      @endforelse
                    </div>
                  </div>
                </div>
              @empty
                <div class="px-4 py-5 text-sm text-slate-500 italic">Este lote no tiene productos.</div>
              @endforelse

              {{-- ===== Fila TOTAL por lote (si hay >1 producto) ===== --}}
              @if($productsTotal > 1)
                @php
                  // Formato "crudo": sin separadores ni decimales para la fila TOTAL.
                  // Para volver a 2 decimales + miles, sustituye $fmtRaw(...) por $fmtPretty(...).
                  $primaryCode = $primaryCode ?: 'PRIM'; // TIP: inyectar desde el controlador, ej. CUP
                  // FUTURO: agregar "moneda secundaria" explícita (ej. USD) y su tasa.
                @endphp

                <div class="px-4 py-3 bg-white">
                  <div class="grid grid-cols-12 gap-4 items-start border-t border-slate-200 pt-3">
                    {{-- Producto (TOTAL a la derecha) --}}
                    <div class="col-span-12 md:col-span-4">
                      <div class="font-semibold text-slate-900 text-right">TOTAL</div>
                    </div>

                    {{-- Costo TOTAL (crudo) --}}
                    <div class="col-span-6 md:col-span-2">
                      <div class="font-semibold text-slate-900 leading-tight">
                        @if(!empty($usdRate) && $usdRate>0)
                            {{ $fmtRaw($sumCostUSD) }}
                            <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass('USD') }}">USD</small><br>
                        @endif
                        {{ $fmtRaw($sumCostPrimary) }}
                        <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($primaryCode) }}">{{ $primaryCode }}</small>

                      </div>
                    </div>

                    {{-- Precio TOTAL (crudo) --}}
                    <div class="col-span-6 md:col-span-2">
                      <div class="font-semibold text-slate-900 leading-tight">
                        @if(!empty($usdRate) && $usdRate>0)
                          {{ $fmtRaw($sumPriceUSD) }} <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass('USD') }}">USD</small><br>
                        @endif
                        {{ $fmtRaw($sumPricePrimary) }} <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($primaryCode) }}">{{ $primaryCode }}</small>
                      </div>
                    </div>

                    {{-- Ganancia TOTAL (crudo) --}}
                    <div class="col-span-12 md:col-span-2">
                      <div class="font-semibold text-slate-900 leading-tight">
                        @if(!empty($usdRate) && $usdRate>0)
                          {{ $fmtRaw($sumGainUSD) }} <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass('USD') }}">USD</small><br>
                        @endif
                        {{ $fmtRaw($sumGainPrimary) }} <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($primaryCode) }}">{{ $primaryCode }}</small>
                      </div>
                    </div>

                    {{-- Cantidad (TOTAL): Precio × Cantidad del lote (crudo) --}}
                    <div class="col-span-6 md:col-span-1">
                      <div class="font-semibold text-slate-900 text-right leading-tight">
                        @if(!empty($usdRate) && $usdRate>0)
                          {{ $fmtRaw($sumPriceUSD) }} <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass('USD') }}">USD</small><br>
                        @endif
                        {{ $fmtRaw($sumPricePrimary) }} <small class="ml-1 align-middle {{ $curSmall }} {{ $curClass($primaryCode) }}">{{ $primaryCode }}</small>
                      </div>
                    </div>

                    {{-- Acciones (vacío) --}}
                    <div class="col-span-6 md:col-span-1"></div>
                  </div>
                </div>
              @endif

            </div> {{-- /divide-y --}}
          </div>
        @endforeach

        <div class="mt-6">{{ $batches->links() }}</div>
      @else
        @include('zapatera.admin.inventory.partials.history-flat')
      @endif
    </section>
  </x-admin-layout>
