@extends('layouts.app')

@section('content')
<div class="container py-4">
  <h5 class="mb-3">Inventario por variante</h5>
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr><th>ID</th><th>Producto</th><th>Color</th><th>Talla</th><th>Género</th><th>Stock</th></tr></thead>
      <tbody>
        @foreach($variants as $v)
          <tr>
            <td>{{ $v->id }}</td>
            <td>{{ $v->product->name }} ({{ $v->product->sku }})</td>
            <td>{{ $v->color }}</td>
            <td>{{ $v->talla }}</td>
            <td>{{ $v->genero }}</td>
            <td>{{ $v->stock->qty ?? 0 }}</td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
  {{ $variants->links() }}
</div>
@endsection
