@php
  $isEdit   = isset($gestor);
  $name     = old('name', $gestor->name ?? '');
  $email    = old('email', $gestor->email ?? '');
  $phone    = old('phone', $gestor->phone ?? '');
  $token    = old('token', $gestor->token ?? '');
  $markup   = old('markup_percent', $gestor->markup_percent ?? 0);
  $isActive = (string) old('is_active', (string)($gestor->is_active ?? 1));
  $notes    = old('notes', $gestor->notes ?? '');
@endphp

@if ($errors->any())
  <div class="rounded-md bg-red-50 border border-red-200 px-4 py-3 text-sm text-red-800">
    <ul class="list-disc pl-4">
      @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
@endif

<div class="grid grid-cols-1 md:grid-cols-2 gap-5">
  {{-- Nombre --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Nombre</label>
    <input name="name" value="{{ $name }}" required placeholder="Ej: Juan Pérez"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
  </div>

  {{-- Email --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
    <input type="email" name="email" value="{{ $email }}" placeholder="correo@dominio.com"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
  </div>

  {{-- WhatsApp / Teléfono --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">WhatsApp / Teléfono</label>
    <input name="phone" value="{{ $phone }}" placeholder="+57 300 000 0000"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
  </div>

  {{-- Token (slug) --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Token (slug)</label>
    <input name="token" value="{{ $token }}" placeholder="(opcional) se genera automáticamente"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition placeholder:text-gray-400">
    <p class="text-[11px] text-gray-500 mt-1"><b>token</b> opcional se genera automáticamente</p>
  </div>

  {{-- Markup (%) --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Markup (%)</label>
    <input type="number" name="markup_percent" step="0.01" min="0" value="{{ $markup }}"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
    <p class="text-xs text-gray-500 mt-1">Porcentaje de incremento que aplica sobre el precio base.</p>
  </div>

  {{-- Estado --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Estado</label>
    <select name="is_active"
            class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                   focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
      <option value="1" @selected($isActive==='1')>Activo</option>
      <option value="0" @selected($isActive==='0')>Inactivo</option>
    </select>
  </div>

  {{-- Notas --}}
  <div class="md:col-span-2">
    <label class="block text-sm font-medium text-gray-700 mb-1">Notas</label>
    <textarea name="notes" rows="3"
              class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                     focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition"
              placeholder="Observaciones internas, condiciones, etc.">{{ $notes }}</textarea>
  </div>
</div>

<div class="pt-4 flex items-center gap-3">
  <button class="inline-flex items-center rounded-lg bg-blue-600 px-5 py-2.5 text-white hover:bg-blue-700">
    Guardar
  </button>
  <a href="{{ route('zapatera.admin.gestors.index') }}"
     class="inline-flex items-center rounded-lg border border-gray-300 px-5 py-2.5 text-gray-700 hover:bg-gray-50">
    Cancelar
  </a>
</div>

@push('scripts')
<script>
  // Sugerir token en placeholder si se deja vacío (opcional)
  document.addEventListener('DOMContentLoaded', () => {
    const name  = document.querySelector('input[name="name"]');
    const token = document.querySelector('input[name="token"]');
    if (!name || !token) return;
    const slugify = s => s.toString().normalize('NFD').replace(/[\u0300-\u036f]/g,'')
                      .toLowerCase().trim().replace(/[^a-z0-9]+/g,'-').replace(/^-+|-+$/g,'');
    name.addEventListener('input', () => {
      if (!token.value) token.placeholder = slugify(name.value || '');
    });
  });
</script>
@endpush
