<x-admin-layout title="Gestores - Listado">
    <x-slot:header>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-xl font-semibold text-gray-900">Gestores</h1>
                <p class="text-sm text-gray-500">Administra los gestores que publican y comparten su enlace.</p>
            </div>
            {{-- Badge de roles del usuario (opcional) --}}
            <x-user-role-badges />
        </div>
    </x-slot:header>

    <section class="py-6">
      <div class="max-w-6xl mx-auto px-4">
        <form method="GET" action="{{ route('zapatera.admin.gestors.index') }}"
                class="grid grid-cols-1 md:grid-cols-12 gap-3 mb-5 items-end">

            {{-- Buscar --}}
            <div class="md:col-span-6">
                <label for="q" class="block text-sm font-medium text-gray-700 mb-1">Buscar</label>
                <input id="q" type="text" name="q" value="{{ $q ?? request('q') }}"
                    placeholder="Nombre, email, teléfono, token…"
                    class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" />
            </div>

            {{-- Estado --}}
            <div class="md:col-span-3">
                <label for="is_active" class="block text-sm font-medium text-gray-700 mb-1">Estado</label>
                <select id="is_active" name="is_active"
                        class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                <option value="">— Todos —</option>
                <option value="1" @selected((string)request('is_active') === '1')>Activos</option>
                <option value="0" @selected((string)request('is_active') === '0')>Inactivos</option>
                </select>
            </div>

            {{-- Botones --}}
            <div class="md:col-span-3 flex flex-wrap gap-2">
                <button class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-white bg-indigo-600 hover:bg-indigo-700
                            focus:outline-none focus:ring-2 focus:ring-indigo-500">
                Filtrar
                </button>

                @if(request()->filled('q') || request()->filled('is_active'))
                <a href="{{ route('zapatera.admin.gestors.index') }}"
                    class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-indigo-700 bg-indigo-50 border border-indigo-200
                            hover:bg-indigo-100">
                    Limpiar
                </a>
                @endif

                <a href="{{ route('zapatera.admin.gestors.create') }}"
                class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                        rounded-lg text-sm font-semibold text-white bg-emerald-600 hover:bg-emerald-700">
                + Nuevo gestor
                </a>
            </div>
            </form>


        <div class="overflow-x-auto bg-white rounded-xl shadow ring-1 ring-gray-200">
          <table class="min-w-full table-fixed divide-y divide-gray-200">
            <colgroup>
              <col class="w-2/12"><col class="w-3/12"><col class="w-2/12"><col class="w-2/12"><col class="w-1/12"><col class="w-2/12">
            </colgroup>
            <thead class="bg-gray-50">
              <tr class="text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">
                <th class="px-4 py-3">Nombre</th>
                <th class="px-4 py-3">Email / WhatsApp</th>
                <th class="px-4 py-3">Token</th>
                <th class="px-4 py-3">Markup (%)</th>
                <th class="px-4 py-3">Estado</th>
                <th class="px-4 py-3 text-right">Acciones</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
              @forelse($gestors as $g)
                <tr class="hover:bg-gray-50">
                  <td class="px-4 py-3 text-sm font-semibold text-gray-900 truncate">{{ $g->name }}</td>
                  <td class="px-4 py-3 text-sm text-gray-800">
                    <div class="truncate">{{ $g->email }}</div>
                    <div class="text-gray-500">{{ $g->phone }}</div>
                  </td>
                  <td class="px-4 py-3 text-sm">
                    <div class="flex items-center gap-2">
                      <span class="truncate">{{ $g->token }}</span>
                      <button type="button" class="text-xs text-blue-600 hover:text-blue-700 underline"
                              data-copy="{{ $g->token }}">Copiar</button>
                    </div>
                  </td>
                  <td class="px-4 py-3 text-sm tabular-nums">{{ number_format($g->markup_percent, 2) }}</td>
                  <td class="px-4 py-3">
                    @if($g->is_active)
                      <span class="inline-flex items-center rounded-full bg-green-50 px-2 py-0.5 text-xs font-medium text-green-700 ring-1 ring-inset ring-green-200">Activo</span>
                    @else
                      <span class="inline-flex items-center rounded-full bg-gray-100 px-2 py-0.5 text-xs font-medium text-gray-700 ring-1 ring-inset ring-gray-200">Inactivo</span>
                    @endif
                  </td>
                  <td class="px-4 py-3">
                    <div class="flex items-center justify-end gap-2">
                      <a href="{{ route('zapatera.admin.gestors.edit', $g) }}"
                         class="inline-flex items-center rounded-md border border-gray-300 px-3 py-1.5 text-sm text-gray-700 hover:bg-gray-50">
                        Editar
                      </a>
                      <form method="POST" action="{{ route('zapatera.admin.gestors.destroy', $g) }}"
                            onsubmit="return confirm('¿Eliminar gestor?');">
                        @csrf @method('DELETE')
                        <button class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-sm text-white hover:bg-red-700">
                          Eliminar
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              @empty
                <tr><td colspan="6" class="px-4 py-10 text-center text-sm text-gray-500">Sin resultados</td></tr>
              @endforelse
            </tbody>
          </table>
        </div>

        <div class="mt-4">
          {{ $gestors->links() }}
        </div>
      </div>
    </section>

    @push('scripts')
    <script>
      document.addEventListener('click', (e) => {
        const btn = e.target.closest('[data-copy]');
        if (!btn) return;
        const text = btn.getAttribute('data-copy') || '';
        navigator.clipboard.writeText(text).then(() => {
          btn.textContent = '¡Copiado!';
          setTimeout(() => btn.textContent = 'Copiar', 1200);
        });
      });
    </script>
    @endpush
  </x-admin-layout>
