@php
  $isEdit    = isset($currency);
  $code      = old('code', $currency->code ?? '');
  $name      = old('name', $currency->name ?? '');
  $symbol    = old('symbol', $currency->symbol ?? '');
  $isPrimary = (bool) old('is_primary', $currency->is_primary ?? false);
  $rate      = old('rate_to_primary', $currency->rate_to_primary ?? 1);
  $isActive  = (string) old('is_active', (string)($currency->is_active ?? 1));
@endphp

{{-- Errores --}}
@if ($errors->any())
  <div class="rounded-md bg-red-50 border border-red-200 px-4 py-3 text-sm text-red-800">
    <ul class="list-disc pl-4">
      @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
@endif

<div class="grid grid-cols-1 md:grid-cols-2 gap-5">
  {{-- Código --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Código (ISO 4217)</label>
    <input name="code" value="{{ $code }}" required maxlength="10" placeholder="USD, EUR, MXN…"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition uppercase">
    <p class="text-xs text-gray-500 mt-1">Suele ser de 3 letras (ej. USD)</p>
  </div>

  {{-- Nombre --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Nombre</label>
    <input name="name" value="{{ $name }}" required placeholder="Dólar estadounidense"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
  </div>

  {{-- Símbolo --}}
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Símbolo</label>
    <input name="symbol" value="{{ $symbol }}" required placeholder="$, €, Bs, S/…"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
  </div>

  {{-- ¿Principal? --}}
  <div class="flex items-end">
    <label class="inline-flex items-center gap-2 select-none">
      <input type="checkbox" name="is_primary" value="1"
             {{ $isPrimary ? 'checked' : '' }}
             class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
      <span class="text-sm text-gray-700">Moneda principal</span>
    </label>
  </div>

  {{-- Tasa vs principal --}}
  <div class="md:col-span-2">
    <label class="block text-sm font-medium text-gray-700 mb-1">Tasa frente a la moneda principal</label>
    <input type="number" name="rate_to_primary" step="0.000001" min="0" value="{{ $rate }}"
           class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                  focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
    <p class="text-xs text-gray-500 mt-1">
      Si esta moneda es <b>principal</b>, usa <b>1.000000</b>.
    </p>
  </div>

  {{-- Estado --}}
  <div class="md:col-span-2">
    <label class="block text-sm font-medium text-gray-700 mb-1">Estado</label>
    <select name="is_active"
            class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                   focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
      <option value="1" @selected($isActive==='1')>Activa</option>
      <option value="0" @selected($isActive==='0')>Inactiva</option>
    </select>
  </div>
</div>

<div class="pt-4 flex items-center gap-3">
  <button class="inline-flex items-center rounded-lg bg-blue-600 px-5 py-2.5 text-white hover:bg-blue-700">
    Guardar
  </button>
  <a href="{{ route('zapatera.admin.currencies.index') }}"
     class="inline-flex items-center rounded-lg border border-gray-300 px-5 py-2.5 text-gray-700 hover:bg-gray-50">
    Cancelar
  </a>
</div>

@push('scripts')
<script>
  // Uppercase de código (sólo visual)
  document.addEventListener('DOMContentLoaded', () => {
    const code = document.querySelector('input[name="code"]');
    if (code) code.addEventListener('input', () => code.value = code.value.toUpperCase());
  });
</script>
@endpush
