<x-admin-layout title="Monedas - Listado">

    <x-slot:header>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-xl font-semibold text-gray-900">Monedas</h1  1>
                <p class="text-sm text-gray-500">Administra monedas, tasas y estado.</p>
            </div>
            {{-- Badge de roles del usuario (opcional) --}}
            <x-user-role-badges />
        </div>
    </x-slot:header>

    <section class="py-6">
      <div class="max-w-6xl mx-auto px-4">
        <form method="GET" action="{{ route('zapatera.admin.currencies.index') }}"
            class="grid grid-cols-1 md:grid-cols-12 gap-3 mb-5 items-end">

            <div class="md:col-span-5">
                <label class="block text-sm font-medium text-gray-700 mb-1">Buscar</label>
                <input type="text" name="q" value="{{ $q ?? request('q') }}"
                    placeholder="Nombre de la moneda"
                    class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" />
            </div>

            <div class="md:col-span-7 flex flex-wrap gap-2">
                <button class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-white bg-indigo-600 hover:bg-indigo-700
                            focus:outline-none focus:ring-2 focus:ring-indigo-500">
                Filtrar
                </button>

                @if(request()->filled('q'))
                <a href="{{ route('zapatera.admin.currencies.index') }}"
                    class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-indigo-700 bg-indigo-50 border border-indigo-200
                            hover:bg-indigo-100">
                    Limpiar
                </a>
                @endif

                <a href="{{ route('zapatera.admin.currencies.create') }}"
                class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                        rounded-lg text-sm font-semibold text-white bg-emerald-600 hover:bg-emerald-700">
                + Nueva moneda
                </a>
            </div>
        </form>
        <div class="overflow-x-auto bg-white rounded-xl shadow ring-1 ring-gray-200">
          <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
              <tr class="text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">
                <th class="px-4 py-3">Código</th>
                <th class="px-4 py-3">Nombre</th>
                <th class="px-4 py-3">Símbolo</th>
                <th class="px-4 py-3">Tipo</th>
                <th class="px-4 py-3 text-right">Tasa vs principal</th>
                <th class="px-4 py-3">Estado</th>
                <th class="px-4 py-3 text-right">Acciones</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
              @foreach($currencies as $c)
                <tr class="hover:bg-gray-50">
                  <td class="px-4 py-3 text-sm font-semibold text-gray-900">{{ $c['code'] }}</td>
                  <td class="px-4 py-3 text-sm text-gray-800">{{ $c['name'] }}</td>
                  <td class="px-4 py-3 text-sm text-gray-800">{{ $c['symbol'] }}</td>
                  <td class="px-4 py-3">
                    @if($c->is_primary)
                      <span class="inline-flex items-center rounded-full bg-green-50 px-2 py-0.5 text-xs font-medium text-green-700 ring-1 ring-inset ring-green-200">Principal</span>
                    @else
                      <span class="inline-flex items-center rounded-full bg-gray-100 px-2 py-0.5 text-xs font-medium text-gray-700 ring-1 ring-inset ring-gray-200">Secundaria</span>
                    @endif
                  </td>
                  <td class="px-4 py-3 text-sm text-right tabular-nums text-gray-900">{{ number_format($c->rate_to_primary, 6) }}</td>
                  <td class="px-4 py-3">
                    @if($c->is_active ?? true)
                      <span class="inline-flex items-center rounded-full bg-blue-50 px-2 py-0.5 text-xs font-medium text-blue-700 ring-1 ring-inset ring-blue-200">Activa</span>
                    @else
                      <span class="inline-flex items-center rounded-full bg-gray-100 px-2 py-0.5 text-xs font-medium text-gray-700 ring-1 ring-inset ring-gray-200">Inactiva</span>
                    @endif
                  </td>
                  <td class="px-4 py-3">
                    <div class="flex items-center justify-end gap-2">
                      <a href="{{ route('zapatera.admin.currencies.edit', $c) }}"
                         class="inline-flex items-center rounded-md border border-gray-300 px-3 py-1.5 text-sm text-gray-700 hover:bg-gray-50">
                        Editar
                      </a>
                      <form method="POST" action="{{ route('zapatera.admin.currencies.destroy', $c) }}"
                            onsubmit="return confirm('¿Eliminar moneda?');">
                        @csrf @method('DELETE')
                        <button class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-sm text-white hover:bg-red-700">
                          Eliminar
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>

        @if($currencies instanceof \Illuminate\Pagination\AbstractPaginator)
            <div class="mt-4">
                {{ $currencies->links() }}
            </div>
        @endif
      </div>
    </section>
  </x-admin-layout>
