{{-- form.blade.php --}}
<div class="px-5 py-6"
     x-data="nlxSlugSync({
        initialName: @js(old('name', $category->name ?? '')),
        initialSlug: @js(old('slug', $category->slug ?? '')),
     })">
  @csrf

  {{-- contenedor global para los campos --}}
  <div class="rounded-2xl border border-gray-100 bg-slate-50/30 p-5">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
      {{-- Nombre --}}
      <div>
        <label for="name" class="block text-sm font-medium text-gray-700 mb-1">
          Nombre <span class="text-red-500">*</span>
        </label>
        <input id="name" name="name" type="text"
               x-model="name" x-on:input="maybeSync()"
               class="block w-full rounded-xl border-gray-300 px-3 py-2.5 text-sm
                      focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500" />
        @error('name') <p class="mt-1 text-xs text-rose-600">{{ $message }}</p> @enderror
      </div>

      {{-- Slug --}}
      <div>
        <div class="flex items-center justify-between">
          <label for="slug" class="block text-sm font-medium text-gray-700 mb-1">
            Slug <span class="text-gray-400 text-xs">(opcional)</span>
          </label>
          <button type="button" class="text-xs text-indigo-600 hover:text-indigo-700"
                  x-show="touched" x-on:click="resync()">Regenerar</button>
        </div>
        <input id="slug" name="slug" type="text"
               x-model="slug" x-on:input="touched=true"
               placeholder="se-generara-automaticamente"
               class="block w-full rounded-xl border-gray-300 px-3 py-2.5 text-sm
                      focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500" />
        <p class="mt-1 text-xs text-gray-500">
          Si lo dejas vacío se generará automáticamente desde el nombre.
        </p>
        @error('slug') <p class="mt-1 text-xs text-rose-600">{{ $message }}</p> @enderror
      </div>
    </div>

    {{-- Descripción --}}
    <div class="mt-5">
      <label for="description" class="block text-sm font-medium text-gray-700 mb-1">
        Descripción <span class="text-gray-400 text-xs">(opcional)</span>
      </label>
      <textarea id="description" name="description" rows="4"
                class="block w-full rounded-xl border-gray-300 px-3 py-2.5 text-sm
                       focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500">{{ old('description', $category->description ?? '') }}</textarea>
      @error('description') <p class="mt-1 text-xs text-rose-600">{{ $message }}</p> @enderror
    </div>
  </div>

  {{-- Actions --}}
  <div class="mt-6 flex items-center justify-end gap-3">
    <a href="{{ route('zapatera.admin.categories.index') }}"
       class="inline-flex items-center px-4 py-2.5 rounded-xl text-sm font-medium
              text-gray-700 bg-gray-100 hover:bg-gray-200">
      Cancelar
    </a>
    <button class="inline-flex items-center px-5 py-2.5 rounded-xl text-sm font-semibold text-white
                   bg-indigo-600 hover:bg-indigo-700 shadow-sm hover:shadow transition">
      Guardar
    </button>
  </div>
</div>

@push('scripts')
<script>
function nlxSlugSync({ initialName = '', initialSlug = '' } = {}) {
  return {
    name: initialName,
    slug: initialSlug,
    touched: false,
    toSlug(s){
      return (s||'')
        .normalize('NFD').replace(/[\u0300-\u036f]/g,'')
        .toLowerCase().trim()
        .replace(/[^a-z0-9\s-]/g,'')
        .replace(/\s+/g,'-')
        .replace(/-+/g,'-')
        .slice(0, 80);
    },
    maybeSync(){
      if (!this.touched && (!this.slug || this.slug === this.toSlug(this.slug))) {
        this.slug = this.toSlug(this.name);
      }
    },
    resync(){
      this.slug = this.toSlug(this.name);
      this.touched = false;
    }
  }
}
</script>
@endpush
