<x-admin-layout title="Categorías — Listado">
    <x-slot:header>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-xl font-semibold text-gray-900">Categorías</h1>
                <p class="text-sm text-gray-500">Gestiona y organiza tus categorías.</p>
            </div>
            {{-- Badge de roles del usuario (opcional) --}}
            <x-user-role-badges />
        </div>
    </x-slot:header>
    <section class="py-6">
        <div class="max-w-6xl mx-auto px-4">
            {{-- Filtros --}}
            <form method="GET" action="{{ route('zapatera.admin.categories.index') }}"
                class="grid grid-cols-1 md:grid-cols-12 gap-3 mb-5 items-end">
            <div class="md:col-span-6">
                <label class="block text-sm font-medium text-gray-700 mb-1">Buscar</label>
                <input type="text" name="q" value="{{ $q }}"
                    placeholder="Nombre de la categoría"
                    class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" />
            </div>

            <div class="md:col-span-6 flex flex-wrap gap-2">
                <button class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                            rounded-lg text-sm font-semibold text-white bg-indigo-600 hover:bg-indigo-700
                            focus:outline-none focus:ring-2 focus:ring-indigo-500">
                Filtrar
                </button>
                @if(request()->filled('q'))
                <a href="{{ route('zapatera.admin.categories.index') }}"
                class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                        rounded-lg text-sm font-semibold text-indigo-700 bg-indigo-50 border border-indigo-200
                        hover:bg-indigo-100">
                Limpiar
                </a>
                @endif
                <a href="{{ route('zapatera.admin.categories.create') }}"
                class="inline-flex items-center justify-center px-4 py-2 w-full md:w-auto
                        rounded-lg text-sm font-semibold text-white bg-emerald-600 hover:bg-emerald-700">
                + Nueva categoría
                </a>
            </div>
            </form>

            {{-- Tabla --}}
            <div class="overflow-x-auto rounded-xl border border-gray-200 bg-white shadow-card">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 py-2 text-left text-xs font-semibold text-gray-600">Nombre</th>
                    <th class="px-3 py-2 text-left text-xs font-semibold text-gray-600">Slug</th>
                    <th class="px-3 py-2 text-right text-xs font-semibold text-gray-600"># Productos</th>
                    <th class="px-3 py-2 text-right text-xs font-semibold text-gray-600 w-[170px]"></th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 bg-white">
                @forelse($categories as $c)
                <tr class="hover:bg-slate-50/60">
                    <td class="px-3 py-2 font-medium text-gray-900">{{ $c->name }}</td>
                    <td class="px-3 py-2 text-gray-700">{{ $c->slug }}</td>
                    <td class="px-3 py-2 text-right tabular-nums">{{ $c->products_count }}</td>
                    <td class="px-3 py-2 text-right space-x-2">
                    <a href="{{ route('zapatera.admin.categories.edit', $c) }}"
                        class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-3 py-1.5 text-xs font-semibold text-gray-700 hover:bg-gray-50">
                        Editar
                    </a>
                    <form action="{{ route('zapatera.admin.categories.destroy', $c) }}" method="post" class="inline-block"
                            onsubmit="return confirm('¿Eliminar categoría {{ $c->name }}? Esta acción no se puede deshacer.');">
                        @csrf @method('DELETE')
                        <button
                        class="inline-flex items-center rounded-lg border border-rose-200 bg-rose-50 px-3 py-1.5 text-xs font-semibold text-rose-700 hover:bg-rose-100">
                        Eliminar
                        </button>
                    </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="px-3 py-8 text-center text-gray-500">Sin resultados</td>
                </tr>
                @endforelse
                </tbody>
            </table>
            </div>

            <div class="mt-4">{{ $categories->links() }}</div>
        </div>
    </section>
  </x-admin-layout>


  @push('styles')
  <style>
    /* Ajustes del embed para que la imagen grande aproveche el espacio */
    #galleryModalBody .amz-grid{ grid-template-columns: 84px minmax(0,1fr); gap:12px; min-height:70vh; }
    #galleryModalBody .amz-thumbs{ min-width:84px; }
    #galleryModalBody .amz-thumb{ width:60px; height:60px; }
    #galleryModalBody .amz-thumb img{ width:60px; height:60px; object-fit:cover; }
    #galleryModalBody .amz-stage{ min-height:70vh; }
    #galleryModalBody #amz-main{ max-width:98%; max-height:85vh; width:auto; height:auto; object-fit:contain; }
    #galleryModalBody .amz-close{ display:none !important; } /* evita X duplicada */
    @media (max-width:768px){
      #galleryModalBody .amz-grid{ grid-template-columns: minmax(0,1fr); min-height:60vh; }
      #galleryModalBody #amz-main{ max-height:70vh; }
    }
  </style>
  @endpush

  @push('scripts')
  <script>
  // Mantener ambas formas: modal-embed vs. página completa
  document.addEventListener('click', (e) => {
    const a = e.target.closest('a[aria-label="Ver galería del producto"]');
    if (!a) return;
    if (e.ctrlKey || e.metaKey || e.shiftKey || e.button === 1) return; // nueva pestaña
    e.preventDefault();
    window.dispatchEvent(new CustomEvent('gallery:open', { detail: { url: a.href }}));
  });

  function galleryModal() {
    return {
      isOpen: false, bodyEl: null,
      init(){ this.bodyEl = this.$refs.body; },
      open({ url }){
        this.isOpen = true; this._spinner();
        const u = new URL(url, window.location.origin); u.searchParams.set('embed','1');
        fetch(u, { headers:{'X-Requested-With':'XMLHttpRequest'} })
          .then(res => {
            if (res.status === 204) { this.close(); return null; }
            if (!res.ok) throw new Error('HTTP '+res.status); return res.text();
          })
          .then(html => { if(!html) return; this.bodyEl.innerHTML = html; this._wire(this.bodyEl); })
          .catch(() => { this.close(); });
      },
      close(){ this.isOpen = false; if (this.bodyEl) this.bodyEl.innerHTML=''; },
      _spinner(){
        this.bodyEl.innerHTML = `
          <div class="flex min-h-[60vh] items-center justify-center p-6">
            <div class="text-center">
              <div class="mx-auto mb-2 inline-block h-6 w-6 animate-spin rounded-full border-2 border-gray-300 border-t-indigo-600"></div>
              <div class="text-sm text-gray-500">Cargando galería...</div>
            </div>
          </div>`;
      },
      _wire(root){
        const grid = root.querySelector('.amz-grid'), main = root.querySelector('#amz-main'), thumbs = root.querySelector('.amz-thumbs');
        if (!grid || !main || !thumbs) return;
        const nodes = Array.from(thumbs.querySelectorAll('.amz-thumb'));
        const items = nodes.map(n => ({ url: (n.querySelector('img')?.getAttribute('src') || '') })).filter(x=>x.url);
        let idx = 0;
        const paint = ()=>{ if(!items.length) return; idx=(idx+items.length)%items.length; main.src = items[idx].url; nodes.forEach((t,i)=>t.classList.toggle('active', i===idx)); };
        thumbs.addEventListener('click', e => { const el=e.target.closest('.amz-thumb'); if(!el) return; const i=nodes.indexOf(el); if(i>=0){ idx=i; paint(); }});
        thumbs.addEventListener('mouseover', e => { const el=e.target.closest('.amz-thumb'); if(!el) return; const i=nodes.indexOf(el); if(i>=0 && i!==idx){ idx=i; paint(); }});
        const onKey = e => { if(!this.isOpen || !items.length) return; if(e.key==='ArrowLeft'){ idx--; paint(); } if(e.key==='ArrowRight'){ idx++; paint(); } };
        document.addEventListener('keydown', onKey); this.$watch('isOpen', open => { if(!open) document.removeEventListener('keydown', onKey); });
        paint();
      }
    }
  }
  </script>
  @endpush
