{{-- resources/views/zapatera/admin/categories/edit.blade.php --}}
<x-admin-layout title="Categorías — Editar">
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Editar categoría</h1>
      <p class="text-sm text-gray-500">Actualiza los datos y guarda los cambios.</p>
    </x-slot>

    <section class="space-y-4">
      {{--  @if (session('status'))
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 p-3 text-emerald-700">
          {{ session('status') }}
        </div>
      @endif  --}}

      @if ($errors->any())
        <div class="rounded-lg border border-rose-200 bg-rose-50 p-3 text-rose-700">
          <div class="font-semibold mb-1">Revisa los campos:</div>
          <ul class="list-disc pl-5 text-sm">
            @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <form action="{{ route('zapatera.admin.categories.update',$category) }}" method="post" enctype="multipart/form-data"
            class="rounded-xl border border-gray-200 bg-white p-4 shadow-card">
        @method('PUT') @csrf
        @include('zapatera.admin.categories.partials.form')

        @php
        $checked = $category->defaultAttributeValues->pluck('id')->all(); // ids ya asignados a la categoría
      @endphp

        <div class="mt-8">
            <h2 class="text-lg font-semibold text-gray-900 mb-3">Subcategorías (Atributos) por defecto</h2>

            <div class="rounded-xl border border-gray-200 bg-white p-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 max-h-[360px] overflow-y-auto">
                    @foreach($attributes as $attr)
                    <div>
                        <div class="text-sm font-semibold text-gray-700 mb-2">{{ $attr->name }}</div>

                        <div class="space-y-2">
                        @foreach($attr->values as $val)
                            <label class="flex items-center gap-2 text-sm">
                            <input
                                type="checkbox"
                                name="attribute_values[]"
                                value="{{ $val->id }}"
                                class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                                @checked(in_array($val->id, $checked))
                            >
                            <span>{{ $val->value }}</span>
                            </label>
                        @endforeach
                        </div>
                    </div>
                    @endforeach
                </div>

                {{--  <label class="mt-4 inline-flex items-center gap-2">
                    <input type="checkbox" name="propagate" value="1"
                        class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                    <span class="text-sm text-gray-700">
                    Propagar estos valores a todos los productos de la categoría
                    </span>
                </label>  --}}
            </div>
        </div>


            {{-- Propagar a productos --}}
            <label class="mt-4 inline-flex items-center gap-2">
              <input type="checkbox" name="propagate" value="1"
                     class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
              <span class="text-sm text-gray-700">
                Propagar estos valores a todos los productos de la categoría
              </span>
            </label>
          </div>
      </form>

    </section>
  </x-admin-layout>
