{{-- resources/views/zapatera/admin/categories/edit.blade.php --}}
<x-admin-layout title="Categorías — Editar">
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Editar categoría</h1>
      <p class="text-sm text-gray-500">Actualiza los datos y guarda los cambios.</p>
    </x-slot>

    <section class="space-y-4">
      @if (session('status'))
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 p-3 text-emerald-700">
          {{ session('status') }}
        </div>
      @endif

      @if ($errors->any())
        <div class="rounded-lg border border-rose-200 bg-rose-50 p-3 text-rose-700">
          <div class="font-semibold mb-1">Revisa los campos:</div>
          <ul class="list-disc pl-5 text-sm">
            @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <form action="{{ route('zapatera.admin.categories.update',$category) }}" method="post" enctype="multipart/form-data"
            class="rounded-xl border border-gray-200 bg-white p-4 shadow-card">
        @method('PUT') @csrf
        @include('zapatera.admin.categories.partials.form')
      </form>
    </section>
  </x-admin-layout>
