<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Etiqueta {{ $code }}</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    /* Importante: imprime SIN márgenes del navegador */
    @page { size: 58mm 40mm; margin: 0; }
    html, body { margin: 0; padding: 0; }
    .label {
      width: 58mm; height: 40mm;
      display: flex; flex-direction: column;
      align-items: center; justify-content: center;
      /* para ver en pantalla; en impresión real no necesitas borde */
      border: 0;
    }
    .name { font-size: 10pt; line-height: 1.1; text-align:center; margin: 1mm 3mm 0; max-width: 52mm; }
    .barcode { width: 52mm; height: 16mm; display:block; object-fit: contain; margin-top: 1mm; }
    .code   { font-size: 11pt; margin-top: 1mm; font-family: monospace; }
    @media print {
      .actions { display: none !important; }
    }
  </style>
</head>
<body>
  <div class="actions" style="position:fixed;top:8px;right:8px">
    <button onclick="window.print()">Imprimir</button>
  </div>

  <div class="label">
    @if(!empty($name))
      <div class="name">{{ $name }}</div>
    @endif
    <img class="barcode"
         alt="barcode"
         src="{{ route('zapatera.admin.barcode.preview', ['code' => $code]) }}">
    <div class="code">{{ $code }}</div>
  </div>

  <script>
    // Si querés auto-print:
    window.addEventListener('load', () => setTimeout(()=>window.print(), 200));
  </script>
</body>
</html>
