<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Etiqueta {{ $code }}</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    html,body { margin:0; padding:0; }
    .wrap {
      display:flex; justify-content:center; align-items:center; min-height:100vh;
    }
    .label {
      width: 200px; height: 120px;
      border: 1px dashed #ccc; border-radius: 6px;
      padding: 8px;
      display:flex; flex-direction:column; align-items:center; justify-content:center;
    }
    .label img { max-width: 100%; height: 64px; object-fit: contain; }
    .txt { font: 12px/1.1 monospace; text-align:center; margin-top:4px; }
    .btns { position: fixed; top: 10px; right: 10px; }
    @media print {
      .btns { display:none; }
      .label { border:none; }
      @page { size: auto; margin: 8mm; }
    }
  </style>
</head>
<body>
  <div class="btns">
    <button onclick="window.print()">Imprimir</button>
  </div>
  <div class="wrap">
    <div class="label">
      <img alt="barcode" src="{{ route('zapatera.admin.barcode.preview', ['code' => $code]) }}">
      <div class="txt">{{ $code }}</div>
    </div>
  </div>
  <script>
    // Si quieres imprimir automáticamente:
    // window.addEventListener('load', () => setTimeout(()=>window.print(), 300));
  </script>
</body>
</html>
