@extends('layouts.app')

@section('title','Imprimir etiquetas')

@push('styles')
<style>
  /* Tamaño de etiqueta (ejemplo 50x30 mm aprox). Ajusta a tu papel/impresora */
  .label {
    width: 180px;   /* ~50mm a 96dpi aprox */
    height: 110px;  /* ~30mm */
    border: 1px dashed #ccc;
    border-radius: 6px;
    padding: 6px 8px;
    margin: 6px;
    display: inline-flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    break-inside: avoid;
    page-break-inside: avoid;
  }
  .label .txt { font-size: 11px; line-height: 1.1; text-align:center; }
  .label img { max-width: 100%; height: 56px; object-fit: contain; }
  @media print {
    .no-print { display: none !important; }
    .label { border: none; margin: 0; }
    @page { size: auto; margin: 8mm; }

    .label { page-break-after: always; }
    @media print { @page { size: 58mm 40mm; margin: 0; } }
  }
</style>
@endpush

@section('content')
<div class="container-fluid">
  <div class="d-flex align-items-center justify-content-between mb-3 no-print">
    <h5 class="mb-0">Imprimir etiquetas</h5>
    <div class="d-flex gap-2">
      <form method="get" class="d-flex align-items-center" action="{{ route('zapatera.admin.barcode.print') }}">
        <input type="text" name="q" value="{{ $q }}" class="form-control form-control-sm" placeholder="Buscar por nombre, SKU o barcode..." />
        <button class="btn btn-sm btn-outline-secondary ms-2">Buscar</button>
      </form>
      <button onclick="window.print()" class="btn btn-sm btn-primary">
        <i class="bi bi-printer"></i> Imprimir
      </button>
    </div>
  </div>

  @if($products->count()===0)
    <div class="alert alert-secondary">No hay productos con barcode para imprimir.</div>
  @endif

  <div class="d-flex flex-wrap">
    @foreach($products as $p)
      <div class="label">
        <div class="txt fw-semibold text-truncate" style="max-width:160px" title="{{ $p->name }}">{{ $p->name }}</div>
        <div class="txt text-muted">SKU: {{ $p->sku }}</div>
        <img
          alt="barcode"
          src="{{ route('zapatera.admin.barcode.preview', ['code' => $p->barcode]) }}"
        />
        <div class="txt">{{ $p->barcode }}</div>
      </div>
    @endforeach
  </div>

  <div class="mt-3 no-print">
    {{ $products->links() }}
  </div>
</div>
@endsection
