@csrf

{{-- Errores --}}
@if ($errors->any())
  <div class="rounded-md bg-red-50 border border-red-200 px-4 py-3 text-sm text-red-800">
    <ul class="list-disc pl-5 space-y-1">
      @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
@endif

<div class="grid grid-cols-1 md:grid-cols-2 gap-5">
  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Nombre</label>
    <input
      name="name"
      value="{{ old('name', $attribute->name ?? '') }}"
      required
      class="block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500"
    >
  </div>

  <div>
    <label class="block text-sm font-medium text-gray-700 mb-1">Slug (opcional)</label>
    <input
      name="slug"
      value="{{ old('slug', $attribute->slug ?? '') }}"
      placeholder="se-generara-automaticamente"
      class="block w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 placeholder:text-gray-400"
    >
  </div>

  <div class="md:col-span-2">
    <label class="inline-flex items-center gap-2 mt-1 select-none">
      <input
        type="checkbox"
        name="is_filterable"
        value="1"
        {{ old('is_filterable', $attribute->is_filterable ?? 1) ? 'checked' : '' }}
        class="rounded border-gray-300 text-blue-600 focus:ring-blue-500"
      >
      <span class="text-sm text-gray-700">Usar en filtros del catálogo</span>
    </label>
  </div>
</div>

<div class="flex items-center gap-3 pt-4">
  <button class="inline-flex items-center rounded-lg bg-blue-600 px-4 py-2 text-white hover:bg-blue-700">
    Guardar
  </button>
  <a href="{{ route('zapatera.admin.attributes.index') }}"
     class="inline-flex items-center rounded-lg border border-gray-300 px-4 py-2 text-gray-700 hover:bg-gray-50">
    Cancelar
  </a>
</div>
