<x-admin-layout title="Atributos - Editando">
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Editar atributo #{{ $attribute->id }}</h1>
      <p class="text-sm text-gray-500">Actualiza la información y valores asociados.</p>
    </x-slot>

    <section class="py-6">
      <div class="max-w-6xl mx-auto px-4">
        @if(session('status'))
          <div class="mb-4 rounded-md bg-green-50 border border-green-200 px-4 py-3 text-green-800">
            {{ session('status') }}
          </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">
          {{-- Formulario --}}
          <div class="lg:col-span-5 bg-white rounded-xl shadow ring-1 ring-gray-200">
            <form action="{{ route('zapatera.admin.attributes.update', $attribute) }}" method="POST" class="p-6 space-y-6">
              @method('PUT')
              @include('zapatera.admin.attributes.partials.form', ['attribute' => $attribute])
            </form>
          </div>

          {{-- Valores del atributo --}}
            <div class="lg:col-span-7 bg-white rounded-xl shadow ring-1 ring-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-sm font-semibold text-gray-900">Valores registrados</h3>
                <p class="text-xs text-gray-500">Listado de valores asociados a este atributo.</p>
                </div>

                {{-- Form: agregar nuevo valor (3 controles horizontales) --}}
                <form class="px-6 py-4 border-b border-gray-100 grid grid-cols-1 sm:grid-cols-3 gap-3"
                    method="POST"
                    action="{{ route('zapatera.admin.attributes.values.store', $attribute) }}">
                @csrf
                <div>
                    <label class="block text-xs font-medium text-gray-700 mb-1">Valor</label>
                    <input name="value" required placeholder="Ej: Rojo"
                        class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                                focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
                    @error('value') <p class="text-sm text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="block text-xs font-medium text-gray-700 mb-1">Slug</label>
                    <input name="slug" placeholder="(opcional) se genera automáticamente"
                        class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                                focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition placeholder:text-gray-400">
                    @error('slug') <p class="text-sm text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>
                <div class="flex items-end">
                    <button class="inline-flex items-center rounded-lg bg-blue-600 px-4 py-2 text-white hover:bg-blue-700 w-full sm:w-auto">
                    Agregar
                    </button>
                </div>
                {{-- Línea informativa bajo los inputs y el botón --}}
                <div class="sm:col-span-3 text-xs text-gray-500">
                    <b>slug</b> opcional se genera automáticamente
                </div>
                </form>

                {{-- Tabla de valores (edición inline: clic en Valor o en Slug) --}}
                <div class="overflow-x-auto">
                <table class="min-w-full table-fixed divide-y divide-gray-200">
                    <colgroup>
                    <col class="w-2/5"><col class="w-2/5"><col class="w-1/5">
                    </colgroup>
                    <thead class="bg-gray-50">
                    <tr class="text-left text-xs font-semibold text-gray-600 uppercase">
                        <th class="px-4 py-2">Valor</th>
                        <th class="px-4 py-2">Slug</th>
                        <th class="px-4 py-2 text-right">Acciones</th>
                    </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                    @foreach($values as $v)
                        <tr data-row="{{ $v->id }}" class="hover:bg-gray-50">
                        {{-- VALOR (vista / edición) --}}
                        <td class="px-4 py-2 align-middle">
                            <div class="view">
                            <button type="button" data-edit-trigger data-field="value"
                                    class="text-blue-600 hover:text-blue-700 underline underline-offset-2 decoration-dotted">
                                {{ $v->value }}
                            </button>
                            </div>
                            <div class="edit hidden">
                            <input form="frm-{{ $v->id }}" name="value" required value="{{ $v->value }}"
                                    class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                                            focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
                            </div>
                        </td>

                        {{-- SLUG (vista / edición) --}}
                        <td class="px-4 py-2 align-middle">
                            <div class="view">
                            <button type="button" data-edit-trigger data-field="slug"
                                    class="text-blue-600 hover:text-blue-700 underline underline-offset-2 decoration-dotted">
                                {{ $v->slug }}
                            </button>
                            </div>
                            <div class="edit hidden">
                            <input form="frm-{{ $v->id }}" name="slug" value="{{ $v->slug }}"
                                    class="block w-full rounded-lg border-gray-300 bg-blue-50/30 shadow-sm ring-1 ring-transparent
                                            focus:bg-white focus:ring-blue-300 focus:border-blue-400 transition">
                            <p class="text-[11px] text-gray-500 mt-1">solo letras, números y guiones (-)</p>
                            </div>
                        </td>

                        {{-- ACCIONES --}}
                        <td class="px-4 py-2 align-middle">
                            {{-- Vista normal: solo eliminar --}}
                            <div class="view flex justify-end gap-2">
                            <form method="POST"
                                    action="{{ route('zapatera.admin.attributes.values.destroy', [$attribute, $v]) }}"
                                    onsubmit="return confirm('¿Eliminar este valor?');">
                                @csrf @method('DELETE')
                                <button class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-sm text-white hover:bg-red-700">
                                Eliminar
                                </button>
                            </form>
                            </div>
                            {{-- Edición: guardar / cancelar --}}
                            <div class="edit hidden">
                            <div class="flex justify-end gap-2">
                                <form id="frm-{{ $v->id }}" method="POST"
                                    action="{{ route('zapatera.admin.attributes.values.update', [$attribute, $v]) }}">
                                @csrf @method('PUT')
                                <button class="inline-flex items-center rounded-md bg-blue-600 px-3 py-1.5 text-sm text-white hover:bg-blue-700">
                                    Guardar
                                </button>
                                </form>
                                <button type="button" data-cancel
                                        class="inline-flex items-center rounded-md border border-gray-300 px-3 py-1.5 text-sm text-gray-700 hover:bg-gray-50">
                                Cancelar
                                </button>
                            </div>
                            </div>
                        </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                </div>

                @if(method_exists($values,'links'))
                <div class="px-6 py-4">
                    {{ $values->links() }}
                </div>
                @endif
            </div>

            @push('scripts')
            <script>
            const toggleRow = (tr, edit, field = null) => {
                tr.querySelectorAll('.view').forEach(el => el.classList.toggle('hidden', edit));
                tr.querySelectorAll('.edit').forEach(el => el.classList.toggle('hidden', !edit));

                if (edit) {
                // Si viene de un click en Valor/Slug, enfoca ese campo; si no, enfoca 'value'
                const selector = field ? `.edit input[name="${field}"]` : '.edit input[name="value"]';
                const i = tr.querySelector(selector) || tr.querySelector('.edit input');
                if (i) i.focus();
                }
            };

            document.addEventListener('click', (e) => {
                const trigger = e.target.closest('[data-edit-trigger]');
                if (trigger) {
                const tr = trigger.closest('tr[data-row]');
                const field = trigger.dataset.field || null; // "value" o "slug"
                if (tr) toggleRow(tr, true, field);
                }

                const cancel = e.target.closest('[data-cancel]');
                if (cancel) {
                const tr = cancel.closest('tr[data-row]');
                if (tr) toggleRow(tr, false);
                }
            });

            // ESC para cancelar
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                document.querySelectorAll('tr[data-row]').forEach(tr => toggleRow(tr, false));
                }
            });
            </script>
            @endpush


        </div>
      </div>
    </section>
  </x-admin-layout>
