<x-admin-layout title="Atributos - Editando">
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Editar atributo</h1>
      <p class="text-sm text-gray-500">Actualiza la información y valores asociados.</p>
    </x-slot>

    <section class="py-6">
      <div class="max-w-6xl mx-auto px-4">
        @if(session('status'))
          <div class="mb-4 rounded-md bg-green-50 border border-green-200 px-4 py-3 text-green-800">
            {{ session('status') }}
          </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
          {{-- Formulario --}}
          <div class="lg:col-span-2 bg-white rounded-xl shadow ring-1 ring-gray-200">
            <form action="{{ route('zapatera.admin.attributes.store') }}" method="POST" class="p-6 space-y-6">
              @method('PUT')
              @include('zapatera.admin.attributes.partials.form')
            </form>
          </div>

          {{-- Valores del atributo --}}
          {{--  <div class="bg-white rounded-xl shadow ring-1 ring-gray-200 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
              <h3 class="text-sm font-semibold text-gray-900">Valores registrados</h3>
              <p class="text-xs text-gray-500">Listado de valores asociados a este atributo.</p>
            </div>
            <div class="overflow-x-auto">
              <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                  <tr class="text-left text-xs font-semibold text-gray-600 uppercase">
                    <th class="px-4 py-2">ID</th>
                    <th class="px-4 py-2">Valor</th>
                    <th class="px-4 py-2">Slug</th>
                  </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                  @foreach($values as $v)
                    <tr>
                      <td class="px-4 py-2 text-sm text-gray-700">{{ $v->id }}</td>
                      <td class="px-4 py-2 text-sm font-medium text-gray-900">{{ $v->value }}</td>
                      <td class="px-4 py-2 text-sm text-gray-700"><code class="text-gray-500">{{ $v->slug }}</code></td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>  --}}
        </div>
      </div>
    </section>
  </x-admin-layout>
