<x-admin-layout title="Valores Atributos - Listado">
    {{-- Si quieres, un header nombrado --}}
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Panel general</h1>
      <p class="text-sm text-gray-500">Resumen de actividad y accesos rápidos.</p>
    </x-slot>


    {{-- CONTENIDO PRINCIPAL --}}
    <section>
        <div class="container py-4">
        @if(session('status'))
            <div class="alert alert-success">{{ session('status') }}</div>
        @endif

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Valores de atributo: {{ $attribute->name }}</h5>
            <a class="btn btn-outline-secondary" href="{{ route('zapatera.admin.attributes.index') }}">Volver a atributos</a>
        </div>

        <form class="row g-2 mb-3" action="{{ route('zapatera.admin.attributes.values.store',$attribute) }}" method="post">
            @csrf
            <div class="col-md-4">
            <input class="form-control" name="value" placeholder="Nuevo valor (ej: rojo, 41, cuero)" required>
            </div>
            <div class="col-md-3">
            <input class="form-control" name="slug" placeholder="slug (opcional)">
            </div>
            <div class="col-md-2">
            <button class="btn btn-primary w-100">Añadir</button>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-sm align-middle">
            <thead>
                <tr>
                <th>ID</th>
                <th>Valor</th>
                <th>Slug</th>
                <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse($values as $v)
                <tr>
                    <td>{{ $v->id }}</td>
                    <td>{{ $v->value }}</td>
                    <td><code>{{ $v->slug }}</code></td>
                    <td class="text-end">
                    <a class="btn btn-sm btn-outline-secondary" href="{{ route('zapatera.admin.attributes.values.edit',[$attribute,$v]) }}">Editar</a>
                    <form action="{{ route('zapatera.admin.attributes.values.destroy',[$attribute,$v]) }}" method="post" class="d-inline" onsubmit="return confirm('¿Eliminar valor?')">
                        @csrf @method('DELETE')
                        <button class="btn btn-sm btn-outline-danger">Eliminar</button>
                    </form>
                    </td>
                </tr>
                @empty
                <tr><td colspan="4" class="text-center text-muted">Sin valores</td></tr>
                @endforelse
            </tbody>
            </table>
        </div>

        {{ $values->links() }}
        </div>
    </section>
</x-admin-layout>
