<x-admin-layout title="Periodos contables">
    <x-slot:header>
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-xl font-semibold text-gray-900">Periodos contables</h1>
          <p class="text-sm text-gray-500">Administra los días de trabajo por local.</p>
        </div>
        <x-user-role-badges />
      </div>
    </x-slot:header>

    <section class="py-6">
      <div class="max-w-6xl mx-auto px-4">
        @if(session('status'))
          <div class="mb-4 rounded-md bg-green-50 border border-green-200 px-4 py-3 text-green-800">{{ session('status') }}</div>
        @endif
        @if($errors->any())
          <div class="mb-4 rounded-md bg-red-50 border border-red-200 px-4 py-3 text-red-700">{{ $errors->first() }}</div>
        @endif

        <form method="GET"
            class="flex items-end gap-3 overflow-x-auto whitespace-nowrap px-1
                [&>*]:shrink-0"> {{-- cada hijo no se encoge y queda en una sola fila --}}

            {{-- Buscar --}}
            <div class="flex flex-col w-[22rem]">
            <label class="block text-sm font-medium text-gray-700 mb-1">Buscar</label>
            <input type="text" name="q" value="{{ request('q') }}" placeholder="Descripción"
                    class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" />
            </div>

            {{-- Local --}}
            <div class="flex flex-col w-56">
                <label class="block text-sm font-medium text-gray-700 mb-1">Local</label>
                <select name="local_id"
                        class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm bg-white
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                <option value="">— Todos los locales —</option>
                @foreach($locals as $id => $alias)
                    <option value="{{ $id }}" @selected((string)request('local_id') === (string)$id)>{{ $alias }}</option>
                @endforeach
                </select>
            </div>


            {{-- Estado --}}
            @php $estado = request('estado','all'); @endphp
            <div class="flex flex-col w-44">
            <label class="block text-sm font-medium text-gray-700 mb-1">Estado</label>
            <select name="estado"
                    class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm bg-white
                            focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                <option value="all"       @selected($estado==='all')>Todos</option>
                <option value="activos"   @selected($estado==='activos')>Activos</option>
                <option value="inactivos" @selected($estado==='inactivos')>Inactivos</option>
                <option value="cerrados"  @selected($estado==='cerrados')>Cerrados</option>
            </select>
            </div>

            {{-- Botones --}}
            <div class="flex items-end gap-2">
            <button class="inline-flex items-center justify-center px-4 py-2
                            rounded-lg text-sm font-semibold text-white bg-indigo-600 hover:bg-indigo-700">
                Filtrar
            </button>

            @php
                $hasFilters = collect(request()->only(['q','local_id','estado']))
                            ->filter(fn($v)=> filled($v) && $v!=='all')->isNotEmpty();
            @endphp
            @if($hasFilters)
                <a href="{{ route('zapatera.admin.accounting_period.index') }}"
                class="inline-flex items-center justify-center px-4 py-2
                        rounded-lg text-sm font-semibold text-indigo-700 bg-indigo-50 border border-indigo-200 hover:bg-indigo-100">
                Limpiar
                </a>
            @endif

            <a href="{{ route('zapatera.admin.accounting_period.create') }}"
                class="inline-flex items-center justify-center px-4 py-2
                        rounded-lg text-sm font-semibold text-white bg-emerald-600 hover:bg-emerald-700">
                + Nuevo periodo
            </a>
            </div>
        </form>


        <div class="mt-5 overflow-x-auto bg-white rounded-xl shadow ring-1 ring-gray-200">
          <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
              <tr class="text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">
                <th class="px-4 py-3">Rango</th>
                <th class="px-4 py-3">Días</th>
                <th class="px-4 py-3">Descripción</th>
                <th class="px-4 py-3">Estado</th>
                <th class="px-4 py-3">Local</th>
                <th class="px-4 py-3 text-right">Acciones</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
              @forelse($periods as $p)
                @php $badge = $p->estado_badge; @endphp
                <tr class="hover:bg-gray-50">
                  <td class="px-4 py-3 text-sm">
                    {{ $p->fecha_inicial->format('Y-m-d') }} — {{ $p->fecha_final->format('Y-m-d') }}
                  </td>
                  <td class="px-4 py-3 text-sm tabular-nums">{{ $p->dias() }}</td>
                  <td class="px-4 py-3 text-sm text-gray-800">{{ $p->descripcion ?: '—' }}</td>
                  <td class="px-4 py-3">
                    <span class="inline-flex items-center rounded-full px-2 py-0.5 text-xs font-medium ring-1 ring-inset {{ $badge['class'] }}">
                      {{ $badge['label'] }}
                    </span>
                  </td>
                  <td class="px-4 py-3 text-sm text-gray-700">{{ optional($p->local)->alias ?? '—' }}</td>
                  <td class="px-4 py-3">
                    <div class="flex items-center justify-end gap-2">
                      <a href="{{ route('zapatera.admin.accounting_period.edit', $p) }}"
                         class="inline-flex items-center rounded-md border border-gray-300 px-3 py-1.5 text-sm text-gray-700 hover:bg-gray-50">
                        Editar
                      </a>

                      @if(!$p->cerrado)
                        @if(!$p->activo)
                          <form method="POST" action="{{ route('zapatera.admin.accounting_period.activar',$p) }}">
                            @csrf
                            <button class="inline-flex items-center rounded-md bg-indigo-50 text-indigo-700 border border-indigo-200 px-3 py-1.5 text-sm hover:bg-indigo-100">
                              Activar
                            </button>
                          </form>
                        @else
                          <form method="POST" action="{{ route('zapatera.admin.accounting_period.cerrar',$p) }}">
                            @csrf
                            <button class="inline-flex items-center rounded-md bg-amber-50 text-amber-700 border border-amber-200 px-3 py-1.5 text-sm hover:bg-amber-100">
                              Cerrar
                            </button>
                          </form>
                        @endif
                      @endif

                      <form method="POST" action="{{ route('zapatera.admin.accounting_period.destroy', $p) }}"
                            onsubmit="return confirm('¿Eliminar periodo?');">
                        @csrf @method('DELETE')
                        <button class="inline-flex items-center rounded-md bg-red-600 px-3 py-1.5 text-sm text-white hover:bg-red-700">
                          Eliminar
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              @empty
                <tr><td colspan="6" class="px-4 py-10 text-center text-sm text-gray-500">Sin resultados</td></tr>
              @endforelse
            </tbody>
          </table>
        </div>

        <x-ui.pagination :paginator="$periods" :window="2" :show-summary="false">
            <x-slot:middle>
              <x-ui.per-page class="hidden sm:inline-flex" />
            </x-slot:middle>
        </x-ui.pagination>
      </div>
    </section>
  </x-admin-layout>
