<form method="POST" action="{{ $action }}">
    @csrf
    @if($method !== 'POST') @method($method) @endif

    @if($errors->any())
      <div class="mb-4 rounded-md bg-red-50 border border-red-200 px-4 py-3 text-red-700">
        {{ $errors->first() }}
      </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      {{-- Local --}}
      <div class="md:col-span-3">
        <label class="block text-sm font-medium text-gray-700 mb-1">Local</label>
        <select name="local_id"
                class="block w-full rounded-lg border border-gray-300 px-3 py-2 text-sm
                    bg-white focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500" required>
        {{--  <option value="">— Selecciona un local —</option>  --}}
        @foreach($locals as $id => $alias)
            <option value="{{ $id }}" @selected(old('local_id', $periodo->local_id ?? '')==$id)>{{ $alias }}</option>
        @endforeach
        </select>
      </div>


      <div>
        <label class="block text-sm font-medium text-gray-700">Fecha inicial</label>
        <input type="date" name="fecha_inicial" value="{{ old('fecha_inicial', optional($periodo?->fecha_inicial)->format('Y-m-d')) }}"
               class="mt-1 block w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" required>
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-700">Fecha final</label>
        <input type="date" name="fecha_final" value="{{ old('fecha_final', optional($periodo?->fecha_final)->format('Y-m-d')) }}"
               class="mt-1 block w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" required>
      </div>

      <div class="md:col-span-2">
        <label class="block text-sm font-medium text-gray-700">Descripción</label>
        <input name="descripcion" value="{{ old('descripcion', $periodo->descripcion ?? '') }}"
               class="mt-1 block w-full rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500">
      </div>

      <div class="flex items-center gap-6 md:col-span-2">
        <label class="inline-flex items-center gap-2">
          <input type="checkbox" name="activo" value="1"
                 class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                 @checked(old('activo', $periodo->activo ?? false))>
          <span class="text-sm text-gray-700">Marcar como activo</span>
        </label>

        <label class="inline-flex items-center gap-2">
          <input type="checkbox" name="cerrado" value="1"
                 class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                 @checked(old('cerrado', $periodo->cerrado ?? false))>
          <span class="text-sm text-gray-700">Marcar como cerrado</span>
        </label>
      </div>
    </div>

    <div class="mt-5 flex items-center gap-2">
      <button class="inline-flex items-center justify-center rounded-lg bg-indigo-600 px-4 py-2 text-white hover:bg-indigo-700">
        Guardar
      </button>
      <a href="{{ route('zapatera.admin.accounting_period.index') }}"
         class="inline-flex items-center justify-center rounded-lg border border-gray-300 px-4 py-2 text-gray-700 hover:bg-gray-50">
        Cancelar
      </a>
    </div>
  </form>
