{{-- resources/views/pages/home.blade.php --}}
@extends('layouts.app')

@section('content')
  {{-- Hero como en la maqueta estática --}}
  <section class="nlx-hero py-5">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-7">
            <h1 class="fw-bold">Catálogo de Productos</h1>
            <p class="lead mb-3">Busca el producto de tu preferencia.</p>
            <ul class="mb-0">
              <li>Filtrado por categoría y subcategorías (color, talla, género)</li>
              <li>Selecciona y agrega al carrito</li>
              <li>Pedido directo por WhatsApp</li>
            </ul>
          </div>
      </div>
    </div>
  </section>

  {{-- Contenido principal con sidebar + grid, igual a la maqueta --}}
  <main class="py-4">
    <div class="container">
      <div class="row">
        {{-- Sidebar reutilizable --}}
        @include('zapatera.partials.filters')

        {{-- Columna de catálogo (grid). Si no pasas $products, mostramos cards demo. --}}
        <section class="col-lg-9">
          {{-- buscador opcional, tipo maqueta --}}
          <div class="d-flex justify-content-end mb-3">
            <input class="form-control" style="max-width:320px" type="search" placeholder="Buscar modelo...">
          </div>

          <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-3">
            @php
              $demo = [
                ['name'=>'Runner Pro','sku'=>'RUN-PRO-001','price'=>39.90,'image'=>null,'stock'=>16],
                ['name'=>'Urban Flex','sku'=>'URB-FLX-002','price'=>54.90,'image'=>null,'stock'=>13],
                ['name'=>'Classic Low','sku'=>'CLS-LOW-003','price'=>49.90,'image'=>null,'stock'=>12],
              ];
              $collection = isset($products) ? $products : collect($demo);
              $hasGestor = request()->filled('g');
            @endphp

            @forelse($collection as $p)
              @php
                // soporta ambos formatos: array demo o paginator del controlador
                $name  = is_array($p) ? $p['name']       : ($p['name'] ?? $p['name']);
                $sku   = is_array($p) ? $p['sku']        : ($p['sku'] ?? $p['sku']);
                $img   = is_array($p) ? $p['image']      : ($p['image'] ?? null);
                $stock = is_array($p) ? $p['stock']      : ($p['stock_total'] ?? 0);
                $base  = is_array($p) ? $p['price']      : ($p['base_price'] ?? 0);
                $price = is_array($p) ? $p['price']      : ($p['price'] ?? $base);
              @endphp
              <div class="col">
                <div class="card product-card h-100">
                  @if($img)
                    <img src="{{ asset($img) }}" class="card-img-top" alt="{{ $name }}">
                  @else
                    <div class="ratio ratio-16x9 bg-light"></div>
                  @endif
                  <div class="card-body">
                    <h6 class="card-title mb-1">{{ $name }}</h6>
                    <div class="small text-muted mb-2">SKU {{ $sku }} · Stock total {{ $stock }}</div>
                    <div class="price h5 mb-3">
                      @if($hasGestor)
                        <span class="base me-1">${{ number_format($base,2) }}</span>
                      @endif
                      <span>${{ number_format($price,2) }}</span>
                    </div>
                    <a class="btn btn-primary w-100"
                       href="https://wa.me/{{ urlencode(request('wa','')) }}?text={{ urlencode('Hola! Quiero el modelo '.$name.' (SKU '.$sku.'). Precio $'.number_format($price,2).'. '.(request('g') ? 'Gestor: '.request('g').' ' : '').'Enviado desde Zapatera.') }}"
                       target="_blank">
                      Pedir por WhatsApp
                    </a>
                  </div>
                </div>
              </div>
            @empty
              <div class="col-12">
                <div class="alert alert-secondary">Sin productos para mostrar.</div>
              </div>
            @endforelse
          </div>

          {{-- paginación si $products es LengthAwarePaginator --}}
          @if(isset($products) && method_exists($products,'links'))
            <div class="mt-3">
              {{ $products->withQueryString()->links() }}
            </div>
          @endif
        </section>
      </div>
    </div>
  </main>

  {{-- Botón flotante WhatsApp como en maqueta --}}
  <a class="btn btn-success rounded-pill whatsapp-btn" href="https://wa.me/{{ urlencode(request('wa','')) }}" target="_blank" title="WhatsApp">
    WhatsApp
  </a>
@endsection
