@php $brand = config('app.name','GuineraStore'); @endphp
<!doctype html>
<html lang="es" class="h-full bg-base-bg">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $title ?? $brand }}</title>
    {{-- CSS global --}}
    @vite(['resources/css/app.css'])

    {{-- PRODUCCIÓN: Tom Select por CDN ANTES del JS de la app --}}
    @env('production')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/css/tom-select.css">
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js" defer></script>
    @endenv

    {{-- JS global (tu app) --}}
    @vite(['resources/js/app.js'])

    {{-- SOLO EN PRODUCCIÓN: usar CDN de Tom Select --}}
    @env('production')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/css/tom-select.css">
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js" defer></script>
    @endenv
    <link rel="icon" type="image/png" sizes="512x512" href="{{ asset('img/favicon-512.png') }}">
    <link rel="icon" type="image/png" sizes="192x192" href="{{ asset('img/favicon-192.png') }}">
    <link rel="apple-touch-icon" href="{{ asset('img/apple-touch-icon.png') }}">
    <link rel="shortcut icon" href="{{ asset('img/favicon.ico') }}">

    {{--  <link rel="icon" type="image/png" href="{{ asset('img/favicon.png?v=1.1')">  --}}

    @stack('head')
  </head>
  <body class="min-h-screen flex flex-col">
    {{-- NAVBAR --}}
    <nav class="nlx-navbar">
      <div class="container flex h-16 items-center justify-between">
        <a href="{{ url('/') }}" class="flex items-center gap-2">
          <img src="{{ asset('img/logo.png') }}" alt="Logo" class="rounded" width="28" height="28">
          <span class="font-semibold text-slate-900">{{ $brand }}</span>
        </a>

        <ul class="hidden md:flex items-center gap-4">
          <li><a class="nlx-navlink" href="{{ route('zapatera.admin.panel') }}">Admin</a></li>
          <li><a class="nlx-btn-accent" href="#cta">WhatsApp</a></li>
        </ul>

        <button id="nlx-burger" class="md:hidden inline-flex items-center p-2 rounded hover:bg-gray-100">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-gray-700" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6h16M4 12h16M4 18h16"/>
          </svg>
        </button>
      </div>

      <div id="nlx-mobile" class="nlx-mobile md:hidden hidden">
        <ul class="container py-2 flex flex-col gap-1">
          <li><a class="nlx-navlink block py-2" href="{{ route('zapatera.admin.panel') }}">Admin</a></li>
          <li><a class="nlx-btn-accent mt-1 w-max" href="#cta">WhatsApp</a></li>
        </ul>
      </div>
    </nav>

    {{-- CONTENIDO --}}
    <main class="flex-1">
      @hasSection('content') @yield('content') @else {{ $slot ?? '' }} @endif
    </main>

    {{-- FOOTER --}}
    <footer class="nlx-footer">
      <div class="nlx-footer-inner">
        <div class="flex items-center gap-2">
          <img src="{{ asset('img/logo.png') }}" alt="Logo" class="rounded" width="22" height="22">
          <span class="text-sm text-white/70">© {{ date('Y') }} {{ $brand }}</span>
        </div>
        <div class="text-sm text-white/70">Pedidos vía web - Mensajería</div>
      </div>
    </footer>

    <script>
      document.addEventListener('DOMContentLoaded', () => {
        const b = document.getElementById('nlx-burger');
        const m = document.getElementById('nlx-mobile');
        if (b && m) b.addEventListener('click', () => m.classList.toggle('hidden'));
      });
    </script>
    @stack('scripts')
  </body>
</html>
