@php
  $brand = config('app.name', 'GuineraStore');
@endphp
<!doctype html>
<html lang="es" class="h-full bg-slate-50">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ $title ?? $brand }}</title>
  @vite(['resources/css/app.css','resources/js/app.js'])
</head>
<body class="h-full">

  <!-- Barra superior -->
  <header class="sticky top-0 z-30 bg-white border-b border-slate-200">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-14 flex items-center justify-between">
      <div class="flex items-center gap-3">
        <button x-data @click="$dispatch('sidebar:toggle')"
                class="lg:hidden inline-flex items-center justify-center rounded-md p-2 hover:bg-slate-100">
          <!-- Icono hamburguesa -->
          <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                  d="M3.75 6.75h16.5M3.75 12h16.5M3.75 17.25h16.5"/>
          </svg>
        </button>
        <a href="{{ url('/') }}" class="flex items-center gap-2 font-semibold">
          <img src="/img/logo_dark.png" class="h-6 w-6 rounded" alt="">
          <span>{{ $brand }}</span>
        </a>
      </div>

      <div class="flex items-center gap-3">
        @auth
          <span class="hidden sm:block text-sm text-slate-600">{{ auth()->user()->name }}</span>
          <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button class="text-sm px-3 py-1.5 rounded-md bg-slate-900 text-white hover:bg-slate-800">
              Cerrar sesión
            </button>
          </form>
        @else
          <a href="{{ route('login') }}" class="text-sm px-3 py-1.5 rounded-md bg-slate-900 text-white hover:bg-slate-800">
            Iniciar sesión
          </a>
        @endauth
      </div>
    </div>
  </header>

  <!-- Shell de 2 columnas: sidebar fijo + contenido -->
  <div class="min-h-[calc(100vh-56px)] lg:grid lg:grid-cols-[18rem_minmax(0,1fr)]">

    {{-- Sidebar --}}
    <aside x-data="{open:false}"
           @sidebar:toggle.window="open=!open"
           class="bg-white border-r border-slate-200 lg:static lg:translate-x-0
                  fixed inset-y-0 left-0 z-40 w-72 transform transition-transform duration-200
                  -translate-x-full lg:w-[18rem]"
           :class="{'translate-x-0': open}">
      <div class="h-14 lg:hidden"></div>
      <div class="h-full overflow-y-auto px-4 py-4">
        <div class="text-xs font-semibold text-slate-400 mb-3">Navegación</div>
        @include('partials.admin.sidebar')
      </div>
    </aside>

    {{-- Contenido --}}
    <main class="px-4 sm:px-6 lg:px-8 py-6">
      @yield('content')
    </main>
  </div>

</body>
</html>
